/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.impl;

import java.util.List;
import java.util.Map;
import org.rapidoid.RapidoidThing;
import org.rapidoid.buffer.Buf;
import org.rapidoid.bytes.Bytes;
import org.rapidoid.bytes.BytesUtil;
import org.rapidoid.collection.Coll;
import org.rapidoid.commons.Err;
import org.rapidoid.data.BufRange;
import org.rapidoid.data.BufRanges;
import org.rapidoid.data.KeyValueRanges;
import org.rapidoid.http.HttpContentType;
import org.rapidoid.io.Upload;
import org.rapidoid.log.Log;
import org.rapidoid.net.impl.RapidoidHelper;
import org.rapidoid.u.U;
import org.rapidoid.wrap.IntWrap;

public class HttpParser
extends RapidoidThing {
    private static final byte[] CONNECTION = "Connection:".getBytes();
    private static final byte[] KEEP_ALIVE = "keep-alive".getBytes();
    private static final byte[] CONTENT_LENGTH = "Content-Length:".getBytes();
    private static final byte[] COOKIE = "Cookie".getBytes();
    private static final byte[] CT_MULTIPART_FORM_DATA_BOUNDARY1 = "multipart/form-data; boundary=".getBytes();
    private static final byte[] CT_MULTIPART_FORM_DATA_BOUNDARY2 = "multipart/form-data;boundary=".getBytes();
    private static final byte[] CT_MULTIPART_FORM_DATA = "multipart/form-data".getBytes();
    private static final byte[] CT_FORM_URLENCODED = "application/x-www-form-urlencoded".getBytes();
    private static final byte[] CT_JSON = "application/json".getBytes();
    private static final byte[] CONTENT_TYPE = "Content-Type".getBytes();
    private static final byte[] CONTENT_DISPOSITION = "Content-Disposition".getBytes();
    private static final byte[] FORM_DATA = "form-data;".getBytes();
    private static final byte[] NAME_EQ = "name=".getBytes();
    private static final byte[] FILENAME_EQ = "filename=".getBytes();
    private static final byte[] CHARSET_EQ = "charset=".getBytes();
    private static final byte[] _UTF_8 = "UTF-8".getBytes();
    private static final byte[] _ISO_8859_1 = "ISO-8859-1".getBytes();
    private static final byte[] CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding".getBytes();
    private static final byte[] _7BIT = "7bit".getBytes();
    private static final byte[] _8BIT = "8bit".getBytes();
    private static final byte[] BINARY = "binary".getBytes();
    private static final byte[] GET = "GET".getBytes();

    public void parse(Buf buf, RapidoidHelper helper) {
        Bytes bytes = buf.bytes();
        BufRange protocol = helper.protocol;
        BufRanges headers = helper.headers;
        buf.scanUntil((byte)32, helper.verb);
        buf.scanUntil((byte)32, helper.uri);
        buf.scanLn(protocol);
        helper.isKeepAlive.value = this.detectKeepAlive(buf, helper, bytes, protocol, headers);
        BytesUtil.split((Bytes)bytes, (BufRange)helper.uri, (byte)63, (BufRange)helper.path, (BufRange)helper.query, (boolean)false);
        helper.isGet.value = BytesUtil.matches((Bytes)bytes, (BufRange)helper.verb, (byte[])GET, (boolean)true);
        if (!helper.isGet.value) {
            this.parseBody(buf, helper);
        }
    }

    private boolean detectKeepAlive(Buf buf, RapidoidHelper helper, Bytes bytes, BufRange protocol, BufRanges headers) {
        boolean keepAliveByDefault;
        IntWrap result = helper.integers[0];
        boolean bl = keepAliveByDefault = protocol.isEmpty() || bytes.get(protocol.last()) != 48;
        if (keepAliveByDefault) {
            buf.scanLnLn(headers.reset(), result, (byte)115, (byte)101);
        } else {
            buf.scanLnLn(headers.reset(), result, (byte)118, (byte)101);
        }
        int possibleConnHeaderPos = result.value;
        if (possibleConnHeaderPos < 0) {
            return keepAliveByDefault;
        }
        BufRange possibleConnHdr = headers.get(possibleConnHeaderPos);
        if (BytesUtil.startsWith((Bytes)bytes, (BufRange)possibleConnHdr, (byte[])CONNECTION, (boolean)true)) {
            return !keepAliveByDefault;
        }
        return this.isKeepAlive(bytes, headers, helper, keepAliveByDefault);
    }

    private boolean isKeepAlive(Bytes bytes, BufRanges headers, RapidoidHelper helper, boolean keepAliveByDefault) {
        BufRange connHdr = headers.getByPrefix(bytes, CONNECTION, false);
        return connHdr != null ? this.getKeepAliveValue(bytes, connHdr, helper) : keepAliveByDefault;
    }

    private boolean getKeepAliveValue(Bytes bytes, BufRange connHdr, RapidoidHelper helper) {
        assert (bytes != null);
        assert (connHdr != null);
        BufRange connVal = helper.ranges5.ranges[3];
        connVal.setInterval(connHdr.start + CONNECTION.length, connHdr.limit());
        BytesUtil.trim((Bytes)bytes, (BufRange)connVal);
        return BytesUtil.matches((Bytes)bytes, (BufRange)connVal, (byte[])KEEP_ALIVE, (boolean)false);
    }

    private void parseBody(Buf buf, RapidoidHelper helper) {
        BufRanges headers = helper.headers;
        BufRange body = helper.body;
        BufRange clen = headers.getByPrefix(buf.bytes(), CONTENT_LENGTH, false);
        if (clen != null) {
            BufRange clenValue = helper.ranges5.ranges[helper.ranges5.ranges.length - 1];
            clenValue.setInterval(clen.start + CONTENT_LENGTH.length, clen.limit());
            BytesUtil.trim((Bytes)buf.bytes(), (BufRange)clenValue);
            long len = buf.getN(clenValue);
            U.must((len >= 0L && len <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Invalid body size!");
            buf.scanN((int)len, body);
            Log.debug((String)"Request body complete", (String)"range", (Object)body);
        } else {
            body.reset();
        }
    }

    public void parseParams(Buf buf, KeyValueRanges params, BufRange range) {
        this.parseURLEncodedKV(buf, params, range);
    }

    private void parseURLEncodedKV(Buf buf, KeyValueRanges params, BufRange body) {
        int pos = buf.position();
        int limit = buf.limit();
        buf.position(body.start);
        buf.limit(body.limit());
        while (buf.hasRemaining()) {
            int ind = params.add();
            int which = buf.scanTo((byte)61, (byte)38, params.keys[ind], false);
            if (which != 1) continue;
            buf.scanTo((byte)38, params.values[ind], false);
        }
        buf.position(pos);
        buf.limit(limit);
    }

    public int parseHeaders(Buf buf, int from, int to, KeyValueRanges headersKV, RapidoidHelper helper) {
        int pos = buf.position();
        int limit = buf.limit();
        buf.position(from);
        buf.limit(to);
        BufRanges headers = helper.ranges2.reset();
        buf.scanLnLn(headers);
        this.parseHeadersIntoKV(buf, headers, headersKV, null, helper);
        int bodyPos = buf.position();
        buf.position(pos);
        buf.limit(limit);
        return bodyPos;
    }

    public void parseHeadersIntoKV(Buf buf, BufRanges headers, KeyValueRanges headersKV, KeyValueRanges cookies, RapidoidHelper helper) {
        BufRange cookie = helper.ranges5.ranges[0];
        for (int i = 0; i < headers.count; ++i) {
            BufRange hdr = headers.ranges[i];
            int ind = headersKV.add();
            BufRange key = headersKV.keys[ind];
            BufRange val = headersKV.values[ind];
            assert (!hdr.isEmpty());
            boolean split = BytesUtil.split((Bytes)buf.bytes(), (BufRange)hdr, (byte)58, (BufRange)key, (BufRange)val, (boolean)true);
            U.must((boolean)split, (String)"Invalid HTTP header!");
            if (cookies == null || !BytesUtil.matches((Bytes)buf.bytes(), (BufRange)key, (byte[])COOKIE, (boolean)false)) continue;
            --headersKV.count;
            do {
                BytesUtil.split((Bytes)buf.bytes(), (BufRange)val, (byte)59, (BufRange)cookie, (BufRange)val, (boolean)true);
                int cind = cookies.add();
                BytesUtil.split((Bytes)buf.bytes(), (BufRange)cookie, (byte)61, (BufRange)cookies.keys[cind], (BufRange)cookies.values[cind], (boolean)true);
            } while (!val.isEmpty());
        }
    }

    private boolean parseBody(Buf src, KeyValueRanges headers, BufRange body, KeyValueRanges data, BufRanges dataContentTypes, Map<String, List<Upload>> files, RapidoidHelper helper) {
        if (body.isEmpty()) {
            return true;
        }
        BufRange multipartBoundary = helper.ranges5.ranges[0];
        HttpContentType contentType = this.getContentType(src, headers, multipartBoundary);
        switch (contentType) {
            case MULTIPART: {
                if (multipartBoundary.isEmpty()) {
                    this.detectMultipartBoundary(src, body, multipartBoundary);
                }
                helper.bytes[0] = 45;
                helper.bytes[1] = 45;
                src.get(multipartBoundary, helper.bytes, 2);
                Err.rteIf((boolean)multipartBoundary.isEmpty(), (String)"Invalid multi-part HTTP request!");
                Map autoFiles = Coll.mapOfLists();
                this.parseMultiParts(src, body, data, dataContentTypes, autoFiles, multipartBoundary, helper);
                files.putAll(autoFiles);
                return true;
            }
            case FORM_URLENCODED: {
                byte bodyStart = src.get(body.start);
                if (bodyStart != 123 && bodyStart != 91 && bodyStart != 60) {
                    this.parseURLEncodedKV(src, data, body);
                    return true;
                }
                return false;
            }
            case JSON: {
                return false;
            }
            case OTHER: {
                return false;
            }
            case NOT_FOUND: {
                return false;
            }
        }
        throw Err.notExpected();
    }

    private void detectMultipartBoundary(Buf src, BufRange body, BufRange multipartBoundary) {
        BytesUtil.parseLine((Bytes)src.bytes(), (BufRange)multipartBoundary, (int)body.start, (int)body.limit());
        multipartBoundary.strip(2, 0);
    }

    private void parseMultiParts(Buf src, BufRange body, KeyValueRanges data, BufRanges dataContentTypes, Map<String, List<Upload>> files, BufRange multipartBoundary, RapidoidHelper helper) {
        int start = body.start;
        int limit = body.limit();
        int sepLen = multipartBoundary.length + 2;
        int pos1 = -1;
        try {
            int pos2;
            while ((pos2 = BytesUtil.find((Bytes)src.bytes(), (int)start, (int)limit, (byte[])helper.bytes, (int)0, (int)sepLen, (boolean)true)) >= 0) {
                if (pos1 >= 0 && pos2 >= 0) {
                    int from = pos1 + sepLen + 2;
                    int to = pos2 - 2;
                    this.parseMultiPart(src, data, dataContentTypes, files, helper, from, to);
                }
                pos1 = pos2;
                start = pos2 + sepLen;
            }
        }
        catch (Throwable e) {
            Log.warn((String)"Multipart parse error!", (Throwable)e);
            throw U.rte((String)"Multipart data parse error!", (Throwable)e);
        }
    }

    private void parseMultiPart(Buf src, KeyValueRanges data, BufRanges dataContentTypes, Map<String, List<Upload>> files, RapidoidHelper helper, int from, int to) {
        BufRange encoding;
        KeyValueRanges headers = helper.headersKV.reset();
        BufRange partBody = helper.ranges4.ranges[0];
        BufRange contType = helper.ranges4.ranges[1];
        BufRange contEnc = helper.ranges4.ranges[2];
        BufRange dispo1 = helper.ranges4.ranges[3];
        BufRange dispo2 = helper.ranges4.ranges[4];
        BufRange name = helper.ranges4.ranges[5];
        BufRange filename = helper.ranges4.ranges[6];
        BufRange charset = helper.ranges4.ranges[7];
        int bodyPos = this.parseHeaders(src, from, to, headers, helper);
        partBody.setInterval(bodyPos, to);
        BufRange disposition = headers.get(src, CONTENT_DISPOSITION, false);
        if (!BytesUtil.startsWith((Bytes)src.bytes(), (BufRange)disposition, (byte[])FORM_DATA, (boolean)false)) {
            return;
        }
        disposition.strip(FORM_DATA.length, 0);
        BytesUtil.split((Bytes)src.bytes(), (BufRange)disposition, (byte)59, (BufRange)dispo1, (BufRange)dispo2, (boolean)true);
        if (!this.parseDisposition(src, dispo1, dispo2, name, filename) && !this.parseDisposition(src, dispo2, dispo1, name, filename)) {
            throw U.rte((String)"Unrecognized Content-disposition header!");
        }
        BufRange contentType = headers.get(src, CONTENT_TYPE, false);
        contType.reset();
        contEnc.reset();
        if (Log.isDebugEnabled()) {
            this.checkCharset(src, contType, contEnc, charset, contentType);
        }
        if ((encoding = headers.get(src, CONTENT_TRANSFER_ENCODING, false)) != null) {
            boolean validEncoding = BytesUtil.matches((Bytes)src.bytes(), (BufRange)encoding, (byte[])_7BIT, (boolean)false) || BytesUtil.matches((Bytes)src.bytes(), (BufRange)encoding, (byte[])_8BIT, (boolean)false) || BytesUtil.matches((Bytes)src.bytes(), (BufRange)encoding, (byte[])BINARY, (boolean)false);
            Err.rteIf((!validEncoding ? 1 : 0) != 0, (String)"Invalid Content-transfer-encoding header value!");
        }
        if (filename.isEmpty()) {
            int ind = data.add();
            data.keys[ind].assign(name);
            data.values[ind].assign(partBody);
            if (contentType != null) {
                dataContentTypes.add(contentType.start, contentType.length);
            } else {
                dataContentTypes.add();
            }
        } else {
            String uploadParamName = src.get(name);
            String uploadFilename = src.get(filename);
            byte[] uploadContent = partBody.bytes(src);
            files.get(uploadParamName).add(new Upload(uploadFilename, uploadContent));
        }
    }

    private void checkCharset(Buf src, BufRange contType, BufRange contEnc, BufRange charset, BufRange contentType) {
        if (contentType != null) {
            BytesUtil.split((Bytes)src.bytes(), (BufRange)contentType, (byte)59, (BufRange)contType, (BufRange)contEnc, (boolean)true);
            if (BytesUtil.startsWith((Bytes)src.bytes(), (BufRange)contEnc, (byte[])CHARSET_EQ, (boolean)false)) {
                charset.assign(contEnc);
                charset.strip(CHARSET_EQ.length, 0);
                BytesUtil.trim((Bytes)src.bytes(), (BufRange)charset);
                if (!BytesUtil.matches((Bytes)src.bytes(), (BufRange)charset, (byte[])_UTF_8, (boolean)false) && !BytesUtil.matches((Bytes)src.bytes(), (BufRange)charset, (byte[])_ISO_8859_1, (boolean)false)) {
                    Log.warn((String)"Tipically the UTF-8 and ISO-8859-1 charsets are expected, but received different!", (String)"charset", (Object)src.get(charset));
                }
            }
        }
    }

    private boolean parseDisposition(Buf src, BufRange dispoA, BufRange dispoB, BufRange name, BufRange filename) {
        if (BytesUtil.startsWith((Bytes)src.bytes(), (BufRange)dispoA, (byte[])NAME_EQ, (boolean)false)) {
            name.assign(dispoA);
            name.strip(NAME_EQ.length, 0);
            BytesUtil.trim((Bytes)src.bytes(), (BufRange)name);
            name.strip(1, 1);
            if (BytesUtil.startsWith((Bytes)src.bytes(), (BufRange)dispoB, (byte[])FILENAME_EQ, (boolean)false)) {
                filename.assign(dispoB);
                filename.strip(FILENAME_EQ.length, 0);
                BytesUtil.trim((Bytes)src.bytes(), (BufRange)filename);
                filename.strip(1, 1);
            } else {
                filename.reset();
            }
            return true;
        }
        return false;
    }

    private HttpContentType getContentType(Buf buf, KeyValueRanges headers, BufRange multipartBoundary) {
        BufRange contType = headers.get(buf, CONTENT_TYPE, false);
        if (contType != null) {
            if (BytesUtil.startsWith((Bytes)buf.bytes(), (BufRange)contType, (byte[])CT_FORM_URLENCODED, (boolean)false)) {
                multipartBoundary.reset();
                return HttpContentType.FORM_URLENCODED;
            }
            if (BytesUtil.startsWith((Bytes)buf.bytes(), (BufRange)contType, (byte[])CT_JSON, (boolean)false)) {
                multipartBoundary.reset();
                return HttpContentType.JSON;
            }
            if (BytesUtil.startsWith((Bytes)buf.bytes(), (BufRange)contType, (byte[])CT_MULTIPART_FORM_DATA_BOUNDARY1, (boolean)false)) {
                multipartBoundary.setInterval(contType.start + CT_MULTIPART_FORM_DATA_BOUNDARY1.length, contType.limit());
                return HttpContentType.MULTIPART;
            }
            if (BytesUtil.startsWith((Bytes)buf.bytes(), (BufRange)contType, (byte[])CT_MULTIPART_FORM_DATA_BOUNDARY2, (boolean)false)) {
                multipartBoundary.setInterval(contType.start + CT_MULTIPART_FORM_DATA_BOUNDARY2.length, contType.limit());
                return HttpContentType.MULTIPART;
            }
            if (BytesUtil.startsWith((Bytes)buf.bytes(), (BufRange)contType, (byte[])CT_MULTIPART_FORM_DATA, (boolean)false)) {
                multipartBoundary.reset();
                return HttpContentType.MULTIPART;
            }
        }
        multipartBoundary.reset();
        return contType != null ? HttpContentType.OTHER : HttpContentType.NOT_FOUND;
    }

    public boolean parsePosted(Buf input, KeyValueRanges headersKV, BufRange rBody, KeyValueRanges posted, Map<String, List<Upload>> files, RapidoidHelper helper, Map<String, Object> dest) {
        BufRanges dataContentTypes = helper.ranges3.reset();
        boolean completed = this.parseBody(input, headersKV, rBody, posted, dataContentTypes, files, helper);
        posted.toUrlDecodedParams(input, dest, dataContentTypes);
        return completed;
    }
}

