/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.impl;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rapidoid.RapidoidThing;
import org.rapidoid.cls.Cls;
import org.rapidoid.commons.Str;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class PathPattern
extends RapidoidThing
implements Comparable<PathPattern> {
    public static final String ANY = "_";
    public static final Pattern PATH_PARAM_REGEX = Pattern.compile("\\{([^\\}]+)\\}");
    private static final Pattern PATH_PARAM_PARTS = Pattern.compile("(\\w+)(?::(.+))?");
    private static final String DEFAULT_GROUP_REGEX = "[^/]+";
    private static final Method MATCHER_GROUP = Cls.findMethod(Matcher.class, (String)"group", (Class[])new Class[]{String.class});
    private final String path;
    private final Pattern pattern;
    private final Map<String, String> groups;

    public PathPattern(String path, Pattern pattern, Map<String, String> groups) {
        this.path = path;
        this.pattern = pattern;
        this.groups = groups;
    }

    public static PathPattern from(String path) {
        AtomicInteger counter;
        final Map groups = U.map();
        String regex = Str.replace((String)path, (Pattern)PATH_PARAM_REGEX, (Mapper)new Mapper<String[], String>(counter = new AtomicInteger()){
            final /* synthetic */ AtomicInteger val$counter;
            {
                this.val$counter = atomicInteger;
            }

            public String map(String[] gr) throws Exception {
                return PathPattern.toPathParamRegex(groups, this.val$counter, gr[1]);
            }
        });
        if (regex.equals("/*")) {
            regex = "/" + PathPattern.toPathParamRegex(groups, counter, ANY, ".*");
        } else if (regex.endsWith("/*")) {
            regex = Str.trimr((String)regex, (String)"/*");
            regex = regex + U.frmt((String)"(?:/%s)?", (Object[])new Object[]{PathPattern.toPathParamRegex(groups, counter, ANY, ".*")});
        }
        Pattern pattern = Pattern.compile(regex);
        return new PathPattern(path, pattern, groups);
    }

    private static String toPathParamRegex(Map<String, String> groups, AtomicInteger counter, String group) {
        Matcher m = PATH_PARAM_PARTS.matcher(group);
        U.must((boolean)m.matches(), (String)"Invalid path parameter, expected {var} or {var:regex} syntax!");
        String name = m.group(1);
        String regex = (String)U.or((Object)m.group(2), (Object)DEFAULT_GROUP_REGEX);
        return PathPattern.toPathParamRegex(groups, counter, name, regex);
    }

    private static String toPathParamRegex(Map<String, String> groups, AtomicInteger counter, String name, String regex) {
        String groupId = "g" + counter.incrementAndGet();
        U.must((!groups.containsKey(name) ? 1 : 0) != 0, (String)"Cannot have multiple path parameters with the same name: '%s'", (Object)name);
        groups.put(name, groupId);
        if (!groups.isEmpty()) {
            U.must((MATCHER_GROUP != null ? 1 : 0) != 0, (String)"Named Regex groups are supported starting from JDK 7!");
        }
        return "(?<" + groupId + ">" + regex + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathPattern that = (PathPattern)o;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String getPath() {
        return this.path;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Map<String, String> match(String path) {
        Matcher matcher = this.pattern.matcher(path);
        boolean matches = matcher.matches();
        Map params = null;
        if (matches) {
            params = U.map();
            for (Map.Entry<String, String> e : this.groups.entrySet()) {
                U.notNull((Object)(MATCHER_GROUP != null ? 1 : 0), (String)"Regex matcher", (Object[])new Object[0]);
                String val = (String)Cls.invoke((Method)MATCHER_GROUP, (Object)matcher, (Object[])new Object[]{e.getValue()});
                if (val == null) continue;
                val = Msc.urlDecodeOrKeepOriginal((String)val);
                params.put(e.getKey(), val);
            }
        }
        return params;
    }

    public String toString() {
        return "PathPattern{path='" + this.path + '\'' + ", pattern=" + this.pattern + ", groups=" + this.groups + '}';
    }

    @Override
    public int compareTo(PathPattern that) {
        int lengthDiff = -(this.prefix().length() - that.prefix().length());
        return lengthDiff != 0 ? lengthDiff : this.path.compareTo(that.path);
    }

    public String prefix() {
        String simplifiedPattern = Str.replace((String)this.path, (Pattern)PATH_PARAM_REGEX, (Mapper)new Mapper<String[], String>(){

            public String map(String[] gr) throws Exception {
                return "*";
            }
        });
        String prefix = Str.cutToFirst((String)simplifiedPattern, (String)"*");
        U.must((prefix != null ? 1 : 0) != 0, (String)"Couldn't find pattern segments in the path pattern: %s", (Object)this.path);
        return prefix;
    }

    public static boolean isPattern(String path) {
        return path.contains("*") || path.contains("{");
    }
}

