/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.plugins;

import java.util.Collections;
import java.util.Map;
import org.rapidoid.log.Log;
import org.rapidoid.plugins.Plugin;
import org.rapidoid.u.U;

public abstract class AbstractPlugin
implements Plugin {
    private final String name;
    private volatile Map<String, ?> config = Collections.EMPTY_MAP;
    private volatile boolean active = false;

    public AbstractPlugin(String name) {
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public synchronized void configure(Map<String, ?> config) {
        this.config = config;
        Log.info((String)"Configuring plugin", (String)"name", (Object)this.name, (String)"config", config, (String)"plugin", (Object)this, (String)"active", (Object)this.active);
        this.restart();
    }

    @Override
    public synchronized void restart() {
        Log.info((String)"Restarting plugin", (String)"name", (Object)this.name, (String)"config", this.config, (String)"plugin", (Object)this, (String)"active", (Object)this.active);
        try {
            this.doRestart();
        }
        catch (Exception e) {
            this.active = false;
            Log.error((String)("Cannot initialize/restart the plugin: " + this.name), (Throwable)e);
        }
        Log.info((String)"Plugin is ready", (String)"name", (Object)this.name, (String)"config", this.config, (String)"plugin", (Object)this, (String)"active", (Object)this.active);
        this.active = true;
    }

    public synchronized Map<String, Object> config() {
        return this.config;
    }

    protected void doRestart() throws Exception {
    }

    @Override
    public synchronized boolean isActive() {
        return this.active;
    }

    public <T> T option(String subname, T defaultValue) {
        Object value = this.config().get(subname);
        if (value == null) {
            Log.warn((String)U.frmt((String)"The plugin configuration '%s' was not specified for the plugin '%s', using default: %s", (Object[])new Object[]{subname, this.name, defaultValue}));
            value = defaultValue;
        }
        return (T)value;
    }
}

