/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.plugins.cache;

import org.rapidoid.concurrent.Callback;
import org.rapidoid.concurrent.Future;
import org.rapidoid.concurrent.Promise;
import org.rapidoid.concurrent.Promises;
import org.rapidoid.plugins.cache.ICache;
import org.rapidoid.u.U;

public abstract class AbstractCache<K, V>
implements ICache<K, V> {
    protected final String name;
    protected final long timeToLiveMs;
    protected final boolean allowsDifferentTTLThanInitialized;

    public AbstractCache(String name, long timeToLiveMs, boolean allowsDifferentTTLThanInitialized) {
        this.name = name;
        this.timeToLiveMs = timeToLiveMs;
        this.allowsDifferentTTLThanInitialized = allowsDifferentTTLThanInitialized;
    }

    @Override
    public Future<Void> set(K key, V value, long timeToLiveMs) {
        this.validateTTL(timeToLiveMs);
        Promise promise = Promises.create();
        this.set(key, value, timeToLiveMs, (Callback<Void>)promise);
        return promise;
    }

    @Override
    public Future<V> get(K key) {
        Promise promise = Promises.create();
        this.get(key, (Callback<V>)promise);
        return promise;
    }

    @Override
    public void set(K key, V value, Callback<Void> callback) {
        this.set(key, value, this.timeToLiveMs, callback);
    }

    @Override
    public Future<Void> set(K key, V value) {
        return this.set(key, value, this.timeToLiveMs);
    }

    @Override
    public void set(K key, V value, long timeToLiveMs, Callback<Void> callback) {
        this.validateTTL(timeToLiveMs);
        this.doSet(key, value, timeToLiveMs, callback);
    }

    @Override
    public void get(K key, Callback<V> callback) {
        this.doGet(key, callback);
    }

    private void validateTTL(long ttl) {
        U.argMust((this.allowsDifferentTTLThanInitialized || ttl == this.timeToLiveMs ? 1 : 0) != 0, (String)"The cache implementation doesn't support different timeToLiveMs value than the initially specified: %s", (Object[])new Object[]{this.allowsDifferentTTLThanInitialized});
    }

    protected abstract void doSet(K var1, V var2, long var3, Callback<Void> var5);

    protected abstract void doGet(K var1, Callback<V> var2);
}

