/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.plugins.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.rapidoid.beany.Beany;
import org.rapidoid.beany.Prop;
import org.rapidoid.beany.PropertyFilter;
import org.rapidoid.beany.PropertySelector;
import org.rapidoid.cls.Cls;
import org.rapidoid.concurrent.Callback;
import org.rapidoid.concurrent.Promise;
import org.rapidoid.concurrent.Promises;
import org.rapidoid.lambda.Operation;
import org.rapidoid.lambda.Predicate;
import org.rapidoid.plugins.db.AbstractDBPlugin;
import org.rapidoid.plugins.entities.Entities;
import org.rapidoid.u.U;

public abstract class DBPluginBase
extends AbstractDBPlugin {
    private static final Pattern P_WORD = Pattern.compile("\\w+");
    protected static final PropertyFilter SEARCHABLE_PROPS = new PropertyFilter(){

        public boolean eval(Prop prop) throws Exception {
            return Cls.isAssignableTo((Class)prop.getType(), (Class[])new Class[]{Number.class, String.class, Boolean.class, Enum.class, Date.class});
        }
    };

    public DBPluginBase(String name) {
        super(name);
    }

    @Override
    public String persist(Object record) {
        String id = Beany.getIdIfExists((Object)record);
        if (id == null) {
            return this.insert(record);
        }
        this.update(id, record);
        return id;
    }

    @Override
    public void delete(Object record) {
        this.delete(record.getClass(), Beany.getId((Object)record));
    }

    @Override
    public void update(Object record) {
        this.update(Beany.getId((Object)record), record);
    }

    @Override
    public String insertOrGetId(Object record) {
        String id = Beany.getIdIfExists((Object)record);
        if (id == null) {
            return this.insert(record);
        }
        return id;
    }

    @Override
    public <E> List<E> getAll() {
        throw U.notSupported();
    }

    @Override
    public <E> List<E> getAll(Class<E> clazz, List<String> ids) {
        ArrayList<E> results = new ArrayList<E>();
        for (String id : ids) {
            results.add(this.get(clazz, id));
        }
        return results;
    }

    @Override
    public <E> List<E> getAll(Class<E> clazz, int pageNumber, int pageSize) {
        return U.page(this.getAll(clazz), (int)pageNumber, (int)pageSize);
    }

    public <E> E get(Class<E> clazz, String id) {
        E entity = this.getIfExists(clazz, id);
        if (entity == null) {
            throw U.rte((String)"Cannot find entity with ID=%s", (Object[])new Object[]{id});
        }
        return entity;
    }

    @Override
    public <E> E entity(Class<E> entityType, Map<String, ?> properties) {
        return Entities.create(entityType, properties);
    }

    @Override
    public void refresh(Object entity) {
        String id = Beany.getId((Object)entity);
        Object refreshedEntity = this.get((Class)entity.getClass(), id);
        Beany.update((Object)entity, (Map)Beany.read(refreshedEntity));
    }

    public <E> List<E> find(final Class<E> clazz, final Predicate<E> match, Comparator<E> orderBy) {
        Predicate match2 = new Predicate<E>(){

            public boolean eval(E record) throws Exception {
                return !(clazz != null && !clazz.isAssignableFrom(record.getClass()) || match != null && !match.eval(record));
            }
        };
        return this.sorted(this.find(match2), orderBy);
    }

    protected <E> List<E> sorted(List<E> records, Comparator<E> orderBy) {
        if (orderBy != null) {
            Collections.sort(U.list(records), orderBy);
        }
        return records;
    }

    public <E> List<E> fullTextSearch(String searchPhrase) {
        final String search = searchPhrase.toLowerCase();
        Predicate match = new Predicate<E>(){

            public boolean eval(E record) throws Exception {
                if (record.getClass().getSimpleName().toLowerCase().contains(search)) {
                    return true;
                }
                for (Prop prop : Beany.propertiesOf(record).select((PropertySelector)SEARCHABLE_PROPS)) {
                    String s = String.valueOf(prop.get(record)).toLowerCase();
                    if (!s.contains(search)) continue;
                    return true;
                }
                return false;
            }
        };
        return this.find(match);
    }

    @Override
    public <E> List<E> query(final Class<E> clazz, final String query, final Object ... args) {
        Predicate match = new Predicate<E>(){

            public boolean eval(E record) throws Exception {
                return clazz.isAssignableFrom(record.getClass()) && DBPluginBase.this.matches(record, query, args);
            }
        };
        return this.find(match);
    }

    protected boolean matches(Object record, String query, Object ... args) {
        if (query == null || query.isEmpty()) {
            return true;
        }
        if (P_WORD.matcher(query).matches() && args.length == 1) {
            Object arg;
            Object val = Beany.getPropValue((Object)record, (String)query, null);
            return val == (arg = args[0]) || val != null && val.equals(arg);
        }
        throw new RuntimeException("Query not supported: " + query);
    }

    @Override
    public void transaction(Runnable tx, boolean readonly, Callback<Void> callback) {
        throw U.notSupported();
    }

    @Override
    public void transaction(Runnable transaction, boolean readOnly) {
        Promise promise = Promises.create();
        this.transaction(transaction, readOnly, (Callback<Void>)promise);
        promise.get();
    }

    @Override
    public void deleteAllData() {
        List all = this.getAll();
        for (Object entity : all) {
            this.delete(entity);
        }
    }

    @Override
    public <E> List<E> find(final Predicate<E> match) {
        final ArrayList results = new ArrayList();
        this.each(new Operation<E>(){

            public void execute(E record) throws Exception {
                if (match.eval(record)) {
                    results.add(record);
                }
            }
        });
        return results;
    }

    @Override
    public <E> void each(Operation<E> lambda) {
        for (E record : this.getAll()) {
            try {
                lambda.execute(record);
            }
            catch (ClassCastException classCastException) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public <RESULT> RESULT sql(String sql, Object ... args) {
        throw U.notSupported();
    }

    @Override
    public long size() {
        return U.list(this.getAll()).size();
    }

    protected Object castId(Class<?> clazz, String id) {
        return Cls.convert((String)id, (Class)Beany.property(clazz, (String)"id", (boolean)true).getType());
    }
}

