/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.operation.ParsedCommandLine;

public class EchoVariableHandler
extends CommandHandlerWithHelp {
    public EchoVariableHandler() {
        super("echo");
        new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            @Override
            public Collection<String> getAllCandidates(CommandContext ctx) {
                List<String> specified = ctx.getParsedCommandLine().getOtherProperties();
                if (specified.isEmpty()) {
                    return ctx.getVariables();
                }
                if (ctx.getVariables().isEmpty()) {
                    return Collections.emptyList();
                }
                ArrayList<String> all = new ArrayList<String>(ctx.getVariables());
                all.removeAll(specified);
                return all;
            }
        }), 0, "--variable"){

            @Override
            public boolean canAppearNext(CommandContext ctx) {
                try {
                    if (EchoVariableHandler.this.helpArg.isPresent(ctx.getParsedCommandLine())) {
                        return false;
                    }
                }
                catch (CommandFormatException e) {
                    return false;
                }
                return true;
            }
        };
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandFormatException {
        List<String> values = ctx.getParsedCommandLine().getOtherProperties();
        if (values.isEmpty()) {
            Collection<String> defined = ctx.getVariables();
            if (defined.isEmpty()) {
                return;
            }
            ArrayList<String> pairs = new ArrayList<String>(defined.size());
            for (String var : defined) {
                pairs.add(var + '=' + ctx.getVariable(var));
            }
            Collections.sort(pairs);
            for (String pair : pairs) {
                ctx.printLine(pair);
            }
        } else {
            ctx.printColumns(values);
        }
    }

    @Override
    protected void recognizeArguments(CommandContext ctx) throws CommandFormatException {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        Set<String> propertyNames = args.getPropertyNames();
        if (!propertyNames.isEmpty()) {
            Collection<String> names;
            if (this.helpArg.isPresent(args)) {
                if (propertyNames.size() == 1) {
                    return;
                }
                names = new ArrayList<String>(propertyNames);
                names.remove(this.helpArg.getFullName());
                names.remove(this.helpArg.getShortName());
            } else {
                names = propertyNames;
            }
            throw new CommandFormatException("Unrecognized argument names: " + names);
        }
    }
}

