/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.workmanager;

import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.spi.workmanager.Address;
import org.jboss.logging.Logger;

public class WorkManagerEvent {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)WorkManagerEvent.class.getName());
    private static boolean trace = log.isTraceEnabled();
    public static final int TYPE_JOIN = 0;
    public static final int TYPE_LEAVE = 1;
    public static final int TYPE_UPDATE_SHORT_RUNNING = 2;
    public static final int TYPE_UPDATE_LONG_RUNNING = 3;
    private int type;
    private Address address;
    private long value;

    public WorkManagerEvent(int type, Address address) {
        this(type, address, 0L);
    }

    public WorkManagerEvent(int type, Address address, long value) {
        this.type = type;
        this.address = address;
        this.value = value;
    }

    public int getType() {
        return this.type;
    }

    public Address getAddress() {
        return this.address;
    }

    public long getValue() {
        return this.value;
    }

    public int hashCode() {
        int result = 31;
        result += 7 * this.type;
        return result += 7 * this.address.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof WorkManagerEvent)) {
            return false;
        }
        WorkManagerEvent wme = (WorkManagerEvent)o;
        if (this.type != wme.getType()) {
            return false;
        }
        return this.address.equals((Object)wme.getAddress());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("WorkManagerEvent@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[type=").append(this.type);
        sb.append(" address=").append(this.address);
        sb.append(" value=").append(this.value);
        sb.append("]");
        return sb.toString();
    }
}

