/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.workmanager.notification;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.spi.workmanager.Address;
import org.jboss.jca.core.spi.workmanager.notification.NotificationListener;
import org.jboss.logging.Logger;

public abstract class AbstractNotificationListener
implements NotificationListener {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)AbstractNotificationListener.class.getName());
    private static boolean trace = log.isTraceEnabled();
    protected Map<String, Map<Address, Long>> shortRunning = Collections.synchronizedMap(new HashMap());
    protected Map<String, Map<Address, Long>> longRunning = Collections.synchronizedMap(new HashMap());

    public void join(Address address) {
        Map<Object, Long> sr;
        if (trace) {
            log.tracef("join(%s)", address);
        }
        if ((sr = this.shortRunning.get(address.getWorkManagerId())) == null) {
            sr = Collections.synchronizedMap(new HashMap());
        }
        sr.put(address, 0L);
        this.shortRunning.put(address.getWorkManagerId(), sr);
        Map<Object, Long> lr = this.longRunning.get(address.getWorkManagerId());
        if (lr == null) {
            lr = Collections.synchronizedMap(new HashMap());
        }
        lr.put(address, 0L);
        this.longRunning.put(address.getWorkManagerId(), lr);
    }

    public void leave(Address address) {
        Map<Address, Long> lr;
        Map<Address, Long> sr;
        if (trace) {
            log.tracef("leave(%s)", address);
        }
        if ((sr = this.shortRunning.get(address.getWorkManagerId())) != null) {
            sr.remove(address);
            if (sr.size() > 0) {
                this.shortRunning.put(address.getWorkManagerId(), sr);
            } else {
                this.shortRunning.remove(address.getWorkManagerId());
            }
        }
        if ((lr = this.longRunning.get(address.getWorkManagerId())) != null) {
            lr.remove(address);
            if (lr.size() > 0) {
                this.longRunning.put(address.getWorkManagerId(), lr);
            } else {
                this.longRunning.remove(address.getWorkManagerId());
            }
        }
    }

    public void updateShortRunningFree(Address address, long free) {
        Map<Address, Long> sr;
        if (trace) {
            log.tracef("updateShortRunningFree(%s, %d)", address, free);
        }
        if ((sr = this.shortRunning.get(address.getWorkManagerId())) != null) {
            sr.put(address, free);
            this.shortRunning.put(address.getWorkManagerId(), sr);
        }
    }

    public void updateLongRunningFree(Address address, long free) {
        Map<Address, Long> lr;
        if (trace) {
            log.tracef("updateLongRunningFree(%s, %d)", address, free);
        }
        if ((lr = this.longRunning.get(address.getWorkManagerId())) != null) {
            lr.put(address, free);
            this.longRunning.put(address.getWorkManagerId(), lr);
        }
    }

    public void deltaDoWorkAccepted() {
    }

    public void deltaDoWorkRejected() {
    }

    public void deltaStartWorkAccepted() {
    }

    public void deltaStartWorkRejected() {
    }

    public void deltaScheduleWorkAccepted() {
    }

    public void deltaScheduleWorkRejected() {
    }

    public void deltaWorkSuccessful() {
    }

    public void deltaWorkFailed() {
    }
}

