/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.beanvalidation;

import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.validation.ValidationProviderResolver;
import javax.validation.spi.ValidationProvider;
import org.hibernate.validator.HibernateValidator;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WildFlyProviderResolver
implements ValidationProviderResolver {
    public List<ValidationProvider<?>> getValidationProviders() {
        List<ValidationProvider<?>> providers = this.getValidationProviders(WildFlySecurityManager.getCurrentContextClassLoaderPrivileged());
        if (providers != null && !providers.isEmpty()) {
            return providers;
        }
        return this.getValidationProviders(WildFlySecurityManager.getClassLoaderPrivileged(WildFlyProviderResolver.class));
    }

    private List<ValidationProvider<?>> getValidationProviders(final ClassLoader classLoader) {
        if (WildFlySecurityManager.isChecking()) {
            return (List)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<List<ValidationProvider<?>>>(){

                @Override
                public List<ValidationProvider<?>> run() {
                    return WildFlyProviderResolver.this.loadProviders(classLoader);
                }
            });
        }
        return this.loadProviders(classLoader);
    }

    private List<ValidationProvider<?>> loadProviders(ClassLoader classLoader) {
        Iterator<ValidationProvider> providerIterator = ServiceLoader.load(ValidationProvider.class, classLoader).iterator();
        LinkedList providers = new LinkedList();
        while (providerIterator.hasNext()) {
            try {
                ValidationProvider provider = providerIterator.next();
                if (provider.getClass().getName().equals(HibernateValidator.class.getName())) {
                    providers.addFirst(provider);
                    continue;
                }
                providers.add(provider);
            }
            catch (ServiceConfigurationError e) {}
        }
        return providers;
    }
}

