/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.as.clustering.infinispan.subsystem.CacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.InvalidationCacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.LocalCacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.ReplicatedCacheAdd;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;

public class CacheRemove
extends AbstractRemoveStepHandler {
    static final CacheRemove INSTANCE = new CacheRemove();
    private final Map<String, CacheAdd> handlers = new HashMap<String, CacheAdd>();

    CacheRemove() {
        this.handlers.put("local-cache", LocalCacheAdd.INSTANCE);
        this.handlers.put("invalidation-cache", InvalidationCacheAdd.INSTANCE);
        this.handlers.put("replicated-cache", ReplicatedCacheAdd.INSTANCE);
        this.handlers.put("distributed-cache", DistributedCacheAdd.INSTANCE);
    }

    Set<String> getCacheTypes() {
        return this.handlers.keySet();
    }

    CacheAdd getAddHandler(String cacheType) {
        CacheAdd handler = this.handlers.get(cacheType);
        if (handler == null) {
            throw new IllegalArgumentException(cacheType);
        }
        return handler;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress cacheAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathAddress containerAddress = cacheAddress.subAddress(0, cacheAddress.size() - 1);
        ModelNode containerModel = context.readResourceFromRoot(containerAddress).getModel();
        String cacheType = CacheRemove.getCacheType(operation);
        CacheAdd addHandler = this.getAddHandler(cacheType);
        addHandler.removeRuntimeServices(context, operation, containerModel, model);
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode cacheModel) throws OperationFailedException {
        PathAddress cacheAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathAddress containerAddress = cacheAddress.subAddress(0, cacheAddress.size() - 1);
        ModelNode containerModel = context.readResourceFromRoot(containerAddress).getModel();
        String cacheType = CacheRemove.getCacheType(operation);
        ServiceVerificationHandler verificationHandler = null;
        CacheAdd addHandler = this.getAddHandler(cacheType);
        addHandler.installRuntimeServices(context, operation, containerModel, cacheModel, verificationHandler);
    }

    private static String getCacheType(ModelNode operation) {
        PathAddress cacheAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        return cacheAddress.getLastElement().getKey();
    }
}

