/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.BackupForResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.BackupSiteResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CustomStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.Element;
import org.jboss.as.clustering.infinispan.subsystem.EvictionResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ExpirationResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.FileStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.LockingResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.RemoteStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StateTransferResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StorePropertyResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreWriteBehindResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public final class InfinispanSubsystemXMLReader_2_0
implements XMLElementReader<List<ModelNode>> {
    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{InfinispanExtension.SUBSYSTEM_PATH});
        ModelNode subsystem = Util.createAddOperation((PathAddress)subsystemAddress);
        operations.add(subsystem);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CACHE_CONTAINER: {
                    this.parseContainer(reader, subsystemAddress, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseContainer(XMLExtendedStreamReader reader, PathAddress subsystemAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode container = Util.getEmptyOperation((String)"add", null);
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block19: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block19;
                }
                case ALIASES: {
                    for (String alias : reader.getListAttributeValue(i)) {
                        container.get("aliases").add(alias);
                    }
                    continue block19;
                }
                case DEFAULT_CACHE: {
                    CacheContainerResourceDefinition.DEFAULT_CACHE.parseAndSetParameter(value, container, (XMLStreamReader)reader);
                    continue block19;
                }
                case JNDI_NAME: {
                    CacheContainerResourceDefinition.JNDI_NAME.parseAndSetParameter(value, container, (XMLStreamReader)reader);
                    continue block19;
                }
                case START: {
                    CacheContainerResourceDefinition.START.parseAndSetParameter(value, container, (XMLStreamReader)reader);
                    continue block19;
                }
                case LISTENER_EXECUTOR: {
                    CacheContainerResourceDefinition.LISTENER_EXECUTOR.parseAndSetParameter(value, container, (XMLStreamReader)reader);
                    continue block19;
                }
                case EVICTION_EXECUTOR: {
                    CacheContainerResourceDefinition.EVICTION_EXECUTOR.parseAndSetParameter(value, container, (XMLStreamReader)reader);
                    continue block19;
                }
                case REPLICATION_QUEUE_EXECUTOR: {
                    CacheContainerResourceDefinition.REPLICATION_QUEUE_EXECUTOR.parseAndSetParameter(value, container, (XMLStreamReader)reader);
                    continue block19;
                }
                case MODULE: {
                    CacheContainerResourceDefinition.MODULE.parseAndSetParameter(value, container, (XMLStreamReader)reader);
                    continue block19;
                }
                case STATISTICS_ENABLED: {
                    CacheContainerResourceDefinition.STATISTICS_ENABLED.parseAndSetParameter(value, container, (XMLStreamReader)reader);
                    continue block19;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        PathAddress containerAddress = subsystemAddress.append("cache-container", name);
        container.get("address").set(containerAddress.toModelNode());
        operations.add(container);
        block21: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case TRANSPORT: {
                    this.parseTransport(reader, containerAddress, operations);
                    continue block21;
                }
                case LOCAL_CACHE: {
                    this.parseLocalCache(reader, containerAddress, operations);
                    continue block21;
                }
                case INVALIDATION_CACHE: {
                    this.parseInvalidationCache(reader, containerAddress, operations);
                    continue block21;
                }
                case REPLICATED_CACHE: {
                    this.parseReplicatedCache(reader, containerAddress, operations);
                    continue block21;
                }
                case DISTRIBUTED_CACHE: {
                    this.parseDistributedCache(reader, containerAddress, operations);
                    continue block21;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseTransport(XMLExtendedStreamReader reader, PathAddress containerAddress, List<ModelNode> operations) throws XMLStreamException {
        PathAddress transportAddress = containerAddress.append("transport", "TRANSPORT");
        ModelNode transport = Util.createAddOperation((PathAddress)transportAddress);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STACK: {
                    TransportResourceDefinition.STACK.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block6;
                }
                case CLUSTER: {
                    TransportResourceDefinition.CLUSTER.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block6;
                }
                case EXECUTOR: {
                    TransportResourceDefinition.EXECUTOR.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block6;
                }
                case LOCK_TIMEOUT: {
                    TransportResourceDefinition.LOCK_TIMEOUT.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(transport);
    }

    private void parseCacheAttribute(XMLExtendedStreamReader reader, int index, Attribute attribute, String value, ModelNode cache) throws XMLStreamException {
        switch (attribute) {
            case NAME: {
                CacheResourceDefinition.NAME.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            case START: {
                CacheResourceDefinition.START.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            case JNDI_NAME: {
                CacheResourceDefinition.JNDI_NAME.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            case BATCHING: {
                CacheResourceDefinition.BATCHING.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            case MODULE: {
                CacheResourceDefinition.MODULE.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            case STATISTICS_ENABLED: {
                CacheResourceDefinition.STATISTICS_ENABLED.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
            }
        }
    }

    private void parseClusteredCacheAttribute(XMLExtendedStreamReader reader, int index, Attribute attribute, String value, ModelNode cache) throws XMLStreamException {
        switch (attribute) {
            case ASYNC_MARSHALLING: {
                ClusteredCacheResourceDefinition.ASYNC_MARSHALLING.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            case MODE: {
                ClusteredCacheResourceDefinition.MODE.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            case QUEUE_SIZE: {
                ClusteredCacheResourceDefinition.QUEUE_SIZE.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            case QUEUE_FLUSH_INTERVAL: {
                ClusteredCacheResourceDefinition.QUEUE_FLUSH_INTERVAL.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            case REMOTE_TIMEOUT: {
                ClusteredCacheResourceDefinition.REMOTE_TIMEOUT.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            default: {
                this.parseCacheAttribute(reader, index, attribute, value, cache);
            }
        }
    }

    private void parseLocalCache(XMLExtendedStreamReader reader, PathAddress containerAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode cache = Util.getEmptyOperation((String)"add", null);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            this.parseCacheAttribute(reader, i, attribute, value, cache);
        }
        if (!cache.hasDefined("name")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        this.addCacheNameToAddress(cache, containerAddress, "local-cache");
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            this.parseCacheElement(reader, element, cache, additionalConfigurationOperations);
        }
        operations.add(cache);
        for (ModelNode additionalOperation : additionalConfigurationOperations) {
            operations.add(additionalOperation);
        }
    }

    private void parseDistributedCache(XMLExtendedStreamReader reader, PathAddress containerAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode cache = Util.getEmptyOperation((String)"add", null);
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case OWNERS: {
                    DistributedCacheResourceDefinition.OWNERS.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                    continue block7;
                }
                case SEGMENTS: {
                    DistributedCacheResourceDefinition.SEGMENTS.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                    continue block7;
                }
                case L1_LIFESPAN: {
                    DistributedCacheResourceDefinition.L1_LIFESPAN.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    this.parseClusteredCacheAttribute(reader, i, attribute, value, cache);
                }
            }
        }
        if (!cache.hasDefined("name")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        if (!cache.hasDefined("mode")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.MODE));
        }
        this.addCacheNameToAddress(cache, containerAddress, "distributed-cache");
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                default: 
            }
            this.parseSharedStateCacheElement(reader, element, cache, additionalConfigurationOperations);
        }
        operations.add(cache);
        for (ModelNode additionalOperation : additionalConfigurationOperations) {
            operations.add(additionalOperation);
        }
    }

    private void parseReplicatedCache(XMLExtendedStreamReader reader, PathAddress containerAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode cache = Util.getEmptyOperation((String)"add", null);
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            this.parseClusteredCacheAttribute(reader, i, attribute, value, cache);
        }
        if (!cache.hasDefined("name")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        if (!cache.hasDefined("mode")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.MODE));
        }
        this.addCacheNameToAddress(cache, containerAddress, "replicated-cache");
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                default: 
            }
            this.parseSharedStateCacheElement(reader, element, cache, additionalConfigurationOperations);
        }
        operations.add(cache);
        for (ModelNode additionalOperation : additionalConfigurationOperations) {
            operations.add(additionalOperation);
        }
    }

    private void parseInvalidationCache(XMLExtendedStreamReader reader, PathAddress containerAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode cache = Util.getEmptyOperation((String)"add", null);
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            this.parseClusteredCacheAttribute(reader, i, attribute, value, cache);
        }
        if (!cache.hasDefined("name")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        if (!cache.hasDefined("mode")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.MODE));
        }
        this.addCacheNameToAddress(cache, containerAddress, "invalidation-cache");
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                default: 
            }
            this.parseCacheElement(reader, element, cache, additionalConfigurationOperations);
        }
        operations.add(cache);
        for (ModelNode additionalOperation : additionalConfigurationOperations) {
            operations.add(additionalOperation);
        }
    }

    private void addCacheNameToAddress(ModelNode cache, PathAddress containerAddress, String cacheType) {
        String name = cache.get("name").asString();
        PathAddress cacheAddress = containerAddress.append(cacheType, name);
        cache.get("address").set(cacheAddress.toModelNode());
        cache.remove("name");
    }

    private void parseSharedStateCacheElement(XMLExtendedStreamReader reader, Element element, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        switch (element) {
            case STATE_TRANSFER: {
                this.parseStateTransfer(reader, cache, operations);
                break;
            }
            case BACKUPS: {
                this.parseBackups(reader, cache, operations);
                break;
            }
            case BACKUP_FOR: {
                this.parseBackupFor(reader, cache, operations);
                break;
            }
            default: {
                this.parseCacheElement(reader, element, cache, operations);
            }
        }
    }

    private void parseCacheElement(XMLExtendedStreamReader reader, Element element, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        switch (element) {
            case LOCKING: {
                this.parseLocking(reader, cache, operations);
                break;
            }
            case TRANSACTION: {
                this.parseTransaction(reader, cache, operations);
                break;
            }
            case EVICTION: {
                this.parseEviction(reader, cache, operations);
                break;
            }
            case EXPIRATION: {
                this.parseExpiration(reader, cache, operations);
                break;
            }
            case STORE: {
                this.parseCustomStore(reader, cache, operations);
                break;
            }
            case FILE_STORE: {
                this.parseFileStore(reader, cache, operations);
                break;
            }
            case STRING_KEYED_JDBC_STORE: {
                this.parseStringKeyedJDBCStore(reader, cache, operations);
                break;
            }
            case BINARY_KEYED_JDBC_STORE: {
                this.parseBinaryKeyedJDBCStore(reader, cache, operations);
                break;
            }
            case MIXED_KEYED_JDBC_STORE: {
                this.parseMixedKeyedJDBCStore(reader, cache, operations);
                break;
            }
            case REMOTE_STORE: {
                this.parseRemoteStore(reader, cache, operations);
                break;
            }
            case INDEXING: {
                this.parseIndexing(reader, cache);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private void parseStateTransfer(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        PathAddress stateTransferAddress = PathAddress.pathAddress((ModelNode)cache.get("address")).append("state-transfer", "STATE_TRANSFER");
        ModelNode stateTransfer = Util.createAddOperation((PathAddress)stateTransferAddress);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    StateTransferResourceDefinition.ENABLED.parseAndSetParameter(value, stateTransfer, (XMLStreamReader)reader);
                    continue block5;
                }
                case TIMEOUT: {
                    StateTransferResourceDefinition.TIMEOUT.parseAndSetParameter(value, stateTransfer, (XMLStreamReader)reader);
                    continue block5;
                }
                case CHUNK_SIZE: {
                    StateTransferResourceDefinition.CHUNK_SIZE.parseAndSetParameter(value, stateTransfer, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(stateTransfer);
    }

    private void parseBackupFor(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        PathAddress backupForAddress = PathAddress.pathAddress((ModelNode)cache.get("address")).append("backup-for", "BACKUP_FOR");
        ModelNode backupFor = Util.createAddOperation((PathAddress)backupForAddress);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case REMOTE_CACHE: {
                    BackupForResourceDefinition.REMOTE_CACHE.parseAndSetParameter(value, backupFor, (XMLStreamReader)reader);
                    continue block4;
                }
                case REMOTE_SITE: {
                    BackupForResourceDefinition.REMOTE_SITE.parseAndSetParameter(value, backupFor, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(backupFor);
    }

    private void parseLocking(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        PathAddress lockingAddress = PathAddress.pathAddress((ModelNode)cache.get("address")).append("locking", "LOCKING");
        ModelNode locking = Util.createAddOperation((PathAddress)lockingAddress);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ISOLATION: {
                    LockingResourceDefinition.ISOLATION.parseAndSetParameter(value, locking, (XMLStreamReader)reader);
                    continue block6;
                }
                case STRIPING: {
                    LockingResourceDefinition.STRIPING.parseAndSetParameter(value, locking, (XMLStreamReader)reader);
                    continue block6;
                }
                case ACQUIRE_TIMEOUT: {
                    LockingResourceDefinition.ACQUIRE_TIMEOUT.parseAndSetParameter(value, locking, (XMLStreamReader)reader);
                    continue block6;
                }
                case CONCURRENCY_LEVEL: {
                    LockingResourceDefinition.CONCURRENCY_LEVEL.parseAndSetParameter(value, locking, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(locking);
    }

    private void parseTransaction(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        PathAddress transactionAddress = PathAddress.pathAddress((ModelNode)cache.get("address")).append("transaction", "TRANSACTION");
        ModelNode transaction = Util.createAddOperation((PathAddress)transactionAddress);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STOP_TIMEOUT: {
                    TransactionResourceDefinition.STOP_TIMEOUT.parseAndSetParameter(value, transaction, (XMLStreamReader)reader);
                    continue block5;
                }
                case MODE: {
                    TransactionResourceDefinition.MODE.parseAndSetParameter(value, transaction, (XMLStreamReader)reader);
                    continue block5;
                }
                case LOCKING: {
                    TransactionResourceDefinition.LOCKING.parseAndSetParameter(value, transaction, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(transaction);
    }

    private void parseEviction(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        PathAddress evictionAddress = PathAddress.pathAddress((ModelNode)cache.get("address")).append("eviction", "EVICTION");
        ModelNode eviction = Util.createAddOperation((PathAddress)evictionAddress);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STRATEGY: {
                    EvictionResourceDefinition.STRATEGY.parseAndSetParameter(value, eviction, (XMLStreamReader)reader);
                    continue block4;
                }
                case MAX_ENTRIES: {
                    EvictionResourceDefinition.MAX_ENTRIES.parseAndSetParameter(value, eviction, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(eviction);
    }

    private void parseExpiration(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        PathAddress expirationAddress = PathAddress.pathAddress((ModelNode)cache.get("address")).append("expiration", "EXPIRATION");
        ModelNode expiration = Util.createAddOperation((PathAddress)expirationAddress);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAX_IDLE: {
                    ExpirationResourceDefinition.MAX_IDLE.parseAndSetParameter(value, expiration, (XMLStreamReader)reader);
                    continue block5;
                }
                case LIFESPAN: {
                    ExpirationResourceDefinition.LIFESPAN.parseAndSetParameter(value, expiration, (XMLStreamReader)reader);
                    continue block5;
                }
                case INTERVAL: {
                    ExpirationResourceDefinition.INTERVAL.parseAndSetParameter(value, expiration, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(expiration);
    }

    private void parseCustomStore(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        PathAddress storeAddress = PathAddress.pathAddress((ModelNode)cache.get("address")).append("store", "STORE");
        ModelNode store = Util.createAddOperation((PathAddress)storeAddress);
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: {
                    CustomStoreResourceDefinition.CLASS.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    this.parseStoreAttribute(reader, i, attribute, value, store);
                }
            }
        }
        if (!store.hasDefined("class")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.CLASS));
        }
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        this.parseStoreElements(reader, store, additionalConfigurationOperations);
        operations.add(store);
        operations.addAll(additionalConfigurationOperations);
    }

    private void parseFileStore(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        PathAddress storeAddress = PathAddress.pathAddress((ModelNode)cache.get("address")).append("file-store", "FILE_STORE");
        ModelNode store = Util.createAddOperation((PathAddress)storeAddress);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case RELATIVE_TO: {
                    FileStoreResourceDefinition.RELATIVE_TO.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block4;
                }
                case PATH: {
                    FileStoreResourceDefinition.PATH.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    this.parseStoreAttribute(reader, i, attribute, value, store);
                }
            }
        }
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        this.parseStoreElements(reader, store, additionalConfigurationOperations);
        operations.add(store);
        operations.addAll(additionalConfigurationOperations);
    }

    private void parseRemoteStore(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        PathAddress storeAddress = PathAddress.pathAddress((ModelNode)cache.get("address")).append("remote-store", "REMOTE_STORE");
        ModelNode store = Util.createAddOperation((PathAddress)storeAddress);
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CACHE: {
                    RemoteStoreResourceDefinition.CACHE.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block9;
                }
                case SOCKET_TIMEOUT: {
                    RemoteStoreResourceDefinition.SOCKET_TIMEOUT.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block9;
                }
                case TCP_NO_DELAY: {
                    RemoteStoreResourceDefinition.TCP_NO_DELAY.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block9;
                }
                default: {
                    this.parseStoreAttribute(reader, i, attribute, value, store);
                }
            }
        }
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case REMOTE_SERVER: {
                    this.parseRemoteServer(reader, store.get("remote-servers").add());
                    continue block10;
                }
                case WRITE_BEHIND: {
                    this.parseStoreWriteBehind(reader, store, additionalConfigurationOperations);
                    continue block10;
                }
            }
            this.parseStoreProperty(reader, store, additionalConfigurationOperations);
        }
        if (!store.hasDefined("remote-servers")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Element.REMOTE_SERVER));
        }
        operations.add(store);
        operations.addAll(additionalConfigurationOperations);
    }

    private void parseRemoteServer(XMLExtendedStreamReader reader, ModelNode server) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case OUTBOUND_SOCKET_BINDING: {
                    RemoteStoreResourceDefinition.OUTBOUND_SOCKET_BINDING.parseAndSetParameter(value, server, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseStringKeyedJDBCStore(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        PathAddress storeAddress = PathAddress.pathAddress((ModelNode)cache.get("address")).append("string-keyed-jdbc-store", "STRING_KEYED_JDBC_STORE");
        ModelNode store = Util.createAddOperation((PathAddress)storeAddress);
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DATASOURCE: {
                    JDBCStoreResourceDefinition.DATA_SOURCE.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block8;
                }
                case DIALECT: {
                    JDBCStoreResourceDefinition.DIALECT.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    this.parseStoreAttribute(reader, i, attribute, value, store);
                }
            }
        }
        if (!store.hasDefined("datasource")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.DATASOURCE));
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STRING_KEYED_TABLE: {
                    this.parseJDBCStoreTable(reader, store.get("string-keyed-table").setEmptyObject());
                    continue block9;
                }
                case WRITE_BEHIND: {
                    this.parseStoreWriteBehind(reader, store, additionalConfigurationOperations);
                    continue block9;
                }
            }
            this.parseStoreProperty(reader, store, additionalConfigurationOperations);
        }
        operations.add(store);
        operations.addAll(additionalConfigurationOperations);
    }

    private void parseBinaryKeyedJDBCStore(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        PathAddress storeAddress = PathAddress.pathAddress((ModelNode)cache.get("address")).append("binary-keyed-jdbc-store", "BINARY_KEYED_JDBC_STORE");
        ModelNode store = Util.createAddOperation((PathAddress)storeAddress);
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DATASOURCE: {
                    JDBCStoreResourceDefinition.DATA_SOURCE.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block8;
                }
                case DIALECT: {
                    JDBCStoreResourceDefinition.DIALECT.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    this.parseStoreAttribute(reader, i, attribute, value, store);
                }
            }
        }
        if (!store.hasDefined("datasource")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.DATASOURCE));
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case BINARY_KEYED_TABLE: {
                    this.parseJDBCStoreTable(reader, store.get("binary-keyed-table").setEmptyObject());
                    continue block9;
                }
                case WRITE_BEHIND: {
                    this.parseStoreWriteBehind(reader, store, additionalConfigurationOperations);
                    continue block9;
                }
            }
            this.parseStoreProperty(reader, store, additionalConfigurationOperations);
        }
        operations.add(store);
        operations.addAll(additionalConfigurationOperations);
    }

    private void parseMixedKeyedJDBCStore(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        PathAddress storeAddress = PathAddress.pathAddress((ModelNode)cache.get("address")).append("mixed-keyed-jdbc-store", "MIXED_KEYED_JDBC_STORE");
        ModelNode store = Util.createAddOperation((PathAddress)storeAddress);
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DATASOURCE: {
                    JDBCStoreResourceDefinition.DATA_SOURCE.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block10;
                }
                case DIALECT: {
                    JDBCStoreResourceDefinition.DIALECT.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    this.parseStoreAttribute(reader, i, attribute, value, store);
                }
            }
        }
        if (!store.hasDefined("datasource")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.DATASOURCE));
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STRING_KEYED_TABLE: {
                    this.parseJDBCStoreTable(reader, store.get("string-keyed-table").setEmptyObject());
                    continue block11;
                }
                case BINARY_KEYED_TABLE: {
                    this.parseJDBCStoreTable(reader, store.get("binary-keyed-table").setEmptyObject());
                    continue block11;
                }
                case WRITE_BEHIND: {
                    this.parseStoreWriteBehind(reader, store, additionalConfigurationOperations);
                    continue block11;
                }
                case PROPERTY: {
                    this.parseStoreProperty(reader, store, additionalConfigurationOperations);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(store);
        operations.addAll(additionalConfigurationOperations);
    }

    private void parseJDBCStoreTable(XMLExtendedStreamReader reader, ModelNode table) throws XMLStreamException {
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PREFIX: {
                    JDBCStoreResourceDefinition.PREFIX.parseAndSetParameter(value, table, (XMLStreamReader)reader);
                    continue block10;
                }
                case FETCH_SIZE: {
                    JDBCStoreResourceDefinition.FETCH_SIZE.parseAndSetParameter(value, table, (XMLStreamReader)reader);
                    continue block10;
                }
                case BATCH_SIZE: {
                    JDBCStoreResourceDefinition.BATCH_SIZE.parseAndSetParameter(value, table, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ID_COLUMN: {
                    this.parseJDBCStoreColumn(reader, table.get("id-column").setEmptyObject());
                    continue block11;
                }
                case DATA_COLUMN: {
                    this.parseJDBCStoreColumn(reader, table.get("data-column").setEmptyObject());
                    continue block11;
                }
                case TIMESTAMP_COLUMN: {
                    this.parseJDBCStoreColumn(reader, table.get("timestamp-column").setEmptyObject());
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseJDBCStoreColumn(XMLExtendedStreamReader reader, ModelNode column) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    JDBCStoreResourceDefinition.COLUMN_NAME.parseAndSetParameter(value, column, (XMLStreamReader)reader);
                    continue block4;
                }
                case TYPE: {
                    JDBCStoreResourceDefinition.COLUMN_TYPE.parseAndSetParameter(value, column, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseStoreAttribute(XMLExtendedStreamReader reader, int index, Attribute attribute, String value, ModelNode store) throws XMLStreamException {
        switch (attribute) {
            case SHARED: {
                StoreResourceDefinition.SHARED.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                break;
            }
            case PRELOAD: {
                StoreResourceDefinition.PRELOAD.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                break;
            }
            case PASSIVATION: {
                StoreResourceDefinition.PASSIVATION.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                break;
            }
            case FETCH_STATE: {
                StoreResourceDefinition.FETCH_STATE.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                break;
            }
            case PURGE: {
                StoreResourceDefinition.PURGE.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                break;
            }
            case SINGLETON: {
                StoreResourceDefinition.SINGLETON.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                break;
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
            }
        }
    }

    private void parseStoreElements(XMLExtendedStreamReader reader, ModelNode store, List<ModelNode> operations) throws XMLStreamException {
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case WRITE_BEHIND: {
                    this.parseStoreWriteBehind(reader, store, operations);
                    continue block4;
                }
                case PROPERTY: {
                    this.parseStoreProperty(reader, store, operations);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseStoreWriteBehind(XMLExtendedStreamReader reader, ModelNode store, List<ModelNode> operations) throws XMLStreamException {
        PathAddress writeBehindAddress = PathAddress.pathAddress((ModelNode)store.get("address")).append("write-behind", "WRITE_BEHIND");
        ModelNode writeBehind = Util.createAddOperation((PathAddress)writeBehindAddress);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FLUSH_LOCK_TIMEOUT: {
                    StoreWriteBehindResourceDefinition.FLUSH_LOCK_TIMEOUT.parseAndSetParameter(value, writeBehind, (XMLStreamReader)reader);
                    continue block6;
                }
                case MODIFICATION_QUEUE_SIZE: {
                    StoreWriteBehindResourceDefinition.MODIFICATION_QUEUE_SIZE.parseAndSetParameter(value, writeBehind, (XMLStreamReader)reader);
                    continue block6;
                }
                case SHUTDOWN_TIMEOUT: {
                    StoreWriteBehindResourceDefinition.SHUTDOWN_TIMEOUT.parseAndSetParameter(value, writeBehind, (XMLStreamReader)reader);
                    continue block6;
                }
                case THREAD_POOL_SIZE: {
                    StoreWriteBehindResourceDefinition.THREAD_POOL_SIZE.parseAndSetParameter(value, writeBehind, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(writeBehind);
    }

    private void parseStoreProperty(XMLExtendedStreamReader reader, ModelNode node, List<ModelNode> operations) throws XMLStreamException {
        int attributes = reader.getAttributeCount();
        String propertyName = null;
        block3: for (int i = 0; i < attributes; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    propertyName = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (propertyName == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        String propertyValue = reader.getElementText();
        PathAddress propertyAddress = PathAddress.pathAddress((ModelNode)node.get("address")).append("property", propertyName);
        ModelNode property = Util.createAddOperation((PathAddress)propertyAddress);
        StorePropertyResourceDefinition.VALUE.parseAndSetParameter(propertyValue, property, (XMLStreamReader)reader);
        operations.add(property);
    }

    private void parseIndexing(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            if (attribute != Attribute.INDEX) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            CacheResourceDefinition.INDEXING.parseAndSetParameter(value, node, (XMLStreamReader)reader);
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    int attributes = reader.getAttributeCount();
                    String property = null;
                    block8: for (int i = 0; i < attributes; ++i) {
                        String value = reader.getAttributeValue(i);
                        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case NAME: {
                                property = value;
                                continue block8;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                    }
                    if (property == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
                    }
                    String value = reader.getElementText();
                    CacheResourceDefinition.INDEXING_PROPERTIES.parseAndAddParameterElement(property, value, node, reader);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseBackups(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case BACKUP: {
                    this.parseBackup(reader, cache, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseBackup(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        String site = null;
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SITE: {
                    site = value;
                    continue block10;
                }
                case STRATEGY: {
                    BackupSiteResourceDefinition.STRATEGY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block10;
                }
                case BACKUP_FAILURE_POLICY: {
                    BackupSiteResourceDefinition.FAILURE_POLICY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block10;
                }
                case TIMEOUT: {
                    BackupSiteResourceDefinition.REPLICATION_TIMEOUT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block10;
                }
                case ENABLED: {
                    BackupSiteResourceDefinition.ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (site == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.SITE));
        }
        PathAddress address = PathAddress.pathAddress((ModelNode)cache.get("address")).append("backup", site);
        operation.get("address").set(address.toModelNode());
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case TAKE_OFFLINE: {
                    this.parseTakeOffline(reader, operation);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(operation);
    }

    private void parseTakeOffline(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TAKE_BACKUP_OFFLINE_AFTER_FAILURES: {
                    BackupSiteResourceDefinition.TAKE_OFFLINE_AFTER_FAILURES.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                case TAKE_BACKUP_OFFLINE_MIN_WAIT: {
                    BackupSiteResourceDefinition.TAKE_OFFLINE_MIN_WAIT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }
}

