/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services.bootstrap;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.serialization.spi.ProxyServices;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ProxyServicesImpl
implements ProxyServices {
    private final Module module;

    public ProxyServicesImpl(Module module) {
        this.module = module;
    }

    public ClassLoader getClassLoader(final Class<?> proxiedBeanType) {
        if (!WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return ProxyServicesImpl.this._getClassLoader(proxiedBeanType);
                }
            });
        }
        return this._getClassLoader(proxiedBeanType);
    }

    private ClassLoader _getClassLoader(Class<?> proxiedBeanType) {
        if (proxiedBeanType.getName().startsWith("java")) {
            return this.module.getClassLoader();
        }
        if (proxiedBeanType.getClassLoader() instanceof ModuleClassLoader) {
            ModuleClassLoader loader = (ModuleClassLoader)proxiedBeanType.getClassLoader();
            if (loader.getModule().getModuleLoader() instanceof ServiceModuleLoader) {
                return proxiedBeanType.getClassLoader();
            }
            return this.module.getClassLoader();
        }
        return proxiedBeanType.getClassLoader();
    }

    public void cleanup() {
    }

    public Class<?> loadBeanClass(final String className) {
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return Class.forName(className, true, ProxyServicesImpl.this.getClassLoader(this.getClass()));
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw BeanLogger.LOG.cannotLoadClass((Object)className, (Throwable)pae.getException());
        }
    }
}

