/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.Context;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.BeanDeploymentArchiveMapping;
import org.jboss.weld.bootstrap.ContextHolder;
import org.jboss.weld.bootstrap.WeldStartup;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.util.reflection.instantiation.InstantiatorFactory;

public class DeploymentVisitor {
    private final BeanManagerImpl deploymentManager;
    private final Environment environment;
    private final Deployment deployment;
    private final BeanDeploymentArchiveMapping bdaMapping;
    private final Collection<ContextHolder<? extends Context>> contexts;

    public DeploymentVisitor(BeanManagerImpl deploymentManager, Environment environment, Deployment deployment, Collection<ContextHolder<? extends Context>> contexts, BeanDeploymentArchiveMapping bdaMapping) {
        this.deploymentManager = deploymentManager;
        this.environment = environment;
        this.deployment = deployment;
        this.contexts = contexts;
        this.bdaMapping = bdaMapping;
    }

    public void visit() {
        for (BeanDeploymentArchive archive : this.deployment.getBeanDeploymentArchives()) {
            this.visit(archive, new HashSet<BeanDeploymentArchive>());
        }
    }

    private BeanDeployment visit(BeanDeploymentArchive bda, Set<BeanDeploymentArchive> seenBeanDeploymentArchives) {
        this.copyService(bda, ResourceLoader.class);
        this.copyService(bda, InstantiatorFactory.class);
        WeldStartup.verifyServices(bda.getServices(), this.environment.getRequiredBeanDeploymentArchiveServices());
        if (bda.getId() == null) {
            throw BootstrapLogger.LOG.deploymentArchiveNull(bda);
        }
        BeanDeployment parent = this.bdaMapping.getBeanDeployment(bda);
        if (parent == null) {
            parent = new BeanDeployment(bda, this.deploymentManager, this.deployment.getServices(), this.contexts);
            this.bdaMapping.put(bda, parent);
        }
        seenBeanDeploymentArchives.add(bda);
        for (BeanDeploymentArchive archive : bda.getBeanDeploymentArchives()) {
            BeanDeployment child = !seenBeanDeploymentArchives.contains(archive) ? this.visit(archive, seenBeanDeploymentArchives) : this.bdaMapping.getBeanDeployment(archive);
            parent.getBeanManager().addAccessibleBeanManager(child.getBeanManager());
        }
        return parent;
    }

    private <T extends Service> void copyService(BeanDeploymentArchive archive, Class<T> serviceClass) {
        Service service;
        ServiceRegistry registry = archive.getServices();
        if (!registry.contains(serviceClass) && (service = this.deployment.getServices().get(serviceClass)) != null) {
            registry.add(serviceClass, service);
        }
    }
}

