/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import org.picketlink.idm.config.FileIdentityStoreConfiguration;
import org.picketlink.idm.config.IdentityStoreConfigurationBuilder;
import org.picketlink.idm.config.IdentityStoresConfigurationBuilder;
import org.picketlink.idm.config.SecurityConfigurationException;

public class FileStoreConfigurationBuilder
extends IdentityStoreConfigurationBuilder<FileIdentityStoreConfiguration, FileStoreConfigurationBuilder> {
    private String workingDirectory = "/tmp/pl-idm";
    private boolean preserveState = false;
    private boolean asyncWrite = false;
    private int asyncWriteThreadPool = 5;

    public FileStoreConfigurationBuilder(IdentityStoresConfigurationBuilder builder) {
        super(builder);
    }

    public FileStoreConfigurationBuilder workingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
        return this;
    }

    public FileStoreConfigurationBuilder preserveState(boolean preserveState) {
        this.preserveState = preserveState;
        return this;
    }

    public FileStoreConfigurationBuilder asyncWrite(boolean asyncWrite) {
        this.asyncWrite = asyncWrite;
        return this;
    }

    public FileStoreConfigurationBuilder asyncWriteThreadPool(int poolSize) {
        this.asyncWriteThreadPool = poolSize;
        return this;
    }

    @Override
    protected FileIdentityStoreConfiguration create() {
        return new FileIdentityStoreConfiguration(this.workingDirectory, this.preserveState, this.asyncWrite, this.asyncWriteThreadPool, this.getSupportedTypes(), this.getUnsupportedTypes(), this.getContextInitializers(), this.getCredentialHandlerProperties(), this.getCredentialHandlers(), this.isSupportAttributes(), this.isSupportCredentials());
    }

    @Override
    protected void validate() {
        super.validate();
        if (this.workingDirectory == null) {
            throw new SecurityConfigurationException("You must provide a not null working directory.");
        }
        if (this.asyncWriteThreadPool <= 0) {
            throw new SecurityConfigurationException("The thread pool size must be greater than zero.");
        }
    }

    protected FileStoreConfigurationBuilder readFrom(FileIdentityStoreConfiguration configuration) {
        super.readFrom(configuration);
        this.workingDirectory = configuration.getWorkingDir();
        this.preserveState = !configuration.isAlwaysCreateFiles();
        this.asyncWrite = configuration.isAsyncWrite();
        this.asyncWriteThreadPool = configuration.getAsyncThreadPool();
        return this;
    }
}

