/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.config.Builder;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.IdentityConfigurationChildBuilder;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.NamedIdentityConfigurationBuilder;
import org.picketlink.idm.config.SecurityConfigurationException;

public class IdentityConfigurationBuilder
extends Builder<List<IdentityConfiguration>>
implements IdentityConfigurationChildBuilder {
    private final Map<String, NamedIdentityConfigurationBuilder> namedIdentityConfigurationBuilders = new LinkedHashMap<String, NamedIdentityConfigurationBuilder>();

    public IdentityConfigurationBuilder() {
    }

    public IdentityConfigurationBuilder(List<IdentityConfiguration> configurations) throws SecurityConfigurationException {
        this();
        this.readFrom(configurations);
    }

    @Override
    public NamedIdentityConfigurationBuilder named(String configurationName) {
        if (this.namedIdentityConfigurationBuilders.containsKey(configurationName)) {
            return this.namedIdentityConfigurationBuilders.get(configurationName);
        }
        NamedIdentityConfigurationBuilder namedIdentityConfiguration = new NamedIdentityConfigurationBuilder(configurationName, this);
        this.namedIdentityConfigurationBuilders.put(configurationName, namedIdentityConfiguration);
        return namedIdentityConfiguration;
    }

    @Override
    public IdentityConfiguration build() throws SecurityConfigurationException {
        Object identityConfigurations = this.create();
        if (identityConfigurations.size() > 1) {
            throw IDMMessages.MESSAGES.configBuildMultipleConfigurationExists();
        }
        return (IdentityConfiguration)identityConfigurations.get(0);
    }

    @Override
    public List<IdentityConfiguration> buildAll() throws SecurityConfigurationException {
        return this.create();
    }

    public boolean isConfigured() {
        return !this.namedIdentityConfigurationBuilders.isEmpty();
    }

    @Override
    protected void validate() throws SecurityConfigurationException {
        if (this.namedIdentityConfigurationBuilders.isEmpty()) {
            throw IDMMessages.MESSAGES.configNoConfigurationProvided();
        }
        for (NamedIdentityConfigurationBuilder identityConfigBuilder : this.namedIdentityConfigurationBuilders.values()) {
            try {
                identityConfigBuilder.validate();
            }
            catch (Exception e) {
                throw IDMMessages.MESSAGES.configInvalidConfiguration(identityConfigBuilder.getName());
            }
        }
    }

    @Override
    protected List<IdentityConfiguration> create() throws SecurityConfigurationException {
        ArrayList<IdentityConfiguration> configurations = new ArrayList<IdentityConfiguration>();
        try {
            this.validate();
            for (NamedIdentityConfigurationBuilder identityConfigBuilder : this.namedIdentityConfigurationBuilders.values()) {
                IdentityConfiguration configuration = identityConfigBuilder.create();
                if (configurations.contains(configuration)) {
                    throw IDMMessages.MESSAGES.configMultipleConfigurationsFoundWithSameName(configuration.getName());
                }
                boolean supportCredentials = false;
                for (IdentityStoreConfiguration identityStoreConfiguration : configuration.getStoreConfiguration()) {
                    if (supportCredentials) {
                        throw IDMMessages.MESSAGES.configMultipleConfigurationsFoundWithCredentialSupport();
                    }
                    if (!identityStoreConfiguration.supportsCredential()) continue;
                    supportCredentials = true;
                }
                configurations.add(configuration);
            }
        }
        catch (Exception sce) {
            throw IDMMessages.MESSAGES.configCouldNotCreateConfiguration(sce);
        }
        return configurations;
    }

    @Override
    protected Builder<List<IdentityConfiguration>> readFrom(List<IdentityConfiguration> fromConfiguration) throws SecurityConfigurationException {
        if (fromConfiguration == null || fromConfiguration.isEmpty()) {
            throw IDMMessages.MESSAGES.nullArgument("Configuration to read from.");
        }
        for (IdentityConfiguration identityConfiguration : fromConfiguration) {
            this.named(identityConfiguration.getName()).readFrom(identityConfiguration);
        }
        return this;
    }
}

