/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.driver.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.qpid.proton.driver.Connector;
import org.apache.qpid.proton.driver.Listener;
import org.apache.qpid.proton.driver.impl.DriverImpl;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.TransportFactory;

class ConnectorImpl<C>
implements Connector<C> {
    private static int DEFAULT_BUFFER_SIZE = 65536;
    private static int readBufferSize = Integer.getInteger("pn.receive_buffer_size", DEFAULT_BUFFER_SIZE);
    private static int writeBufferSize = Integer.getInteger("pn.send_buffer_size", DEFAULT_BUFFER_SIZE);
    private final DriverImpl _driver;
    private final Listener<C> _listener;
    private final SocketChannel _channel;
    private final Logger _logger = Logger.getLogger("proton.driver");
    private C _context;
    private Connection _connection;
    private Transport _transport = null;
    private SelectionKey _key;
    private ConnectorState _state = ConnectorState.UNINITIALIZED;
    private ByteBuffer _readBuffer = ByteBuffer.allocate(readBufferSize);
    private ByteBuffer _writeBuffer = ByteBuffer.allocate(writeBufferSize);
    private boolean _readPending = true;

    ConnectorImpl(DriverImpl driver, Listener<C> listener, SocketChannel c, C context, SelectionKey key) {
        this._driver = driver;
        this._listener = listener;
        this._channel = c;
        this._context = context;
        this._key = key;
    }

    void selected() {
        this._readPending = true;
    }

    public void process() throws IOException {
        if (this._channel.isOpen() && this._channel.finishConnect()) {
            if (this._readPending) {
                this.read();
                this._readPending = false;
                if (this.isClosed()) {
                    return;
                }
            } else {
                this.processInput();
            }
            this.write();
        }
    }

    private void read() throws IOException {
        int bytesRead = 0;
        while ((bytesRead = this._channel.read(this._readBuffer)) > 0) {
            this.processInput();
        }
        if (bytesRead == -1) {
            this.close();
        }
    }

    private int processInput() throws IOException {
        this._readBuffer.flip();
        int total = 0;
        while (this._readBuffer.hasRemaining()) {
            int consumed = this._transport.input(this._readBuffer.array(), this._readBuffer.position(), this._readBuffer.remaining());
            if (consumed == -1) continue;
            if (consumed == 0) break;
            this._readBuffer.position(this._readBuffer.position() + consumed);
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "consumed " + consumed + " bytes, " + this._readBuffer.remaining() + " available");
            }
            total += consumed;
        }
        this._readBuffer.compact();
        return total;
    }

    private void write() throws IOException {
        int interest = this._key.interestOps();
        boolean empty = this._writeBuffer.position() == 0;
        boolean done = false;
        while (!done) {
            int produced = this._transport.output(this._writeBuffer.array(), this._writeBuffer.position(), this._writeBuffer.remaining());
            this._writeBuffer.position(this._writeBuffer.position() + produced);
            this._writeBuffer.flip();
            int wrote = this._channel.write(this._writeBuffer);
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "wrote " + wrote + " bytes, " + this._writeBuffer.remaining() + " remaining");
            }
            if (this._writeBuffer.hasRemaining()) {
                this._writeBuffer.compact();
                interest |= 4;
                done = true;
                continue;
            }
            this._writeBuffer.clear();
            interest &= 0xFFFFFFFB;
            done = empty && produced == 0;
            empty = true;
        }
        this._key.interestOps(interest);
    }

    public Listener<C> listener() {
        return this._listener;
    }

    public Sasl sasl() {
        if (this._transport != null) {
            return this._transport.sasl();
        }
        return null;
    }

    public Connection getConnection() {
        return this._connection;
    }

    public void setConnection(Connection connection) {
        this._connection = connection;
        this._transport = TransportFactory.getDefaultTransportFactory().transport(this._connection);
    }

    public C getContext() {
        return this._context;
    }

    public void setContext(C context) {
        this._context = context;
    }

    public void close() {
        if (!this.isClosed()) {
            try {
                this.write();
                this._channel.close();
            }
            catch (IOException e) {
                this._logger.log(Level.SEVERE, "Exception when closing connection", e);
            }
        }
    }

    public boolean isClosed() {
        boolean result = !this._channel.isOpen() || !this._channel.isConnected();
        return result;
    }

    public void destroy() {
        this.close();
        this._driver.removeConnector(this);
    }

    static enum ConnectorState {
        UNINITIALIZED,
        OPENED,
        EOS,
        CLOSED;

    }
}

