/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.impl.LinkImpl;
import org.apache.qpid.proton.engine.impl.ReceiverImpl;
import org.apache.qpid.proton.engine.impl.SenderImpl;
import org.apache.qpid.proton.engine.impl.TransportDelivery;

public class DeliveryImpl
implements Delivery {
    private DeliveryImpl _linkPrevious;
    private DeliveryImpl _linkNext;
    private DeliveryImpl _workNext;
    private DeliveryImpl _workPrev;
    private DeliveryImpl _transportWorkNext;
    private DeliveryImpl _transportWorkPrev;
    private Object _context;
    private final byte[] _tag;
    private final LinkImpl _link;
    private DeliveryState _deliveryState;
    private boolean _settled;
    private boolean _remoteSettled;
    private DeliveryState _remoteDeliveryState;
    private static final int DELIVERY_STATE_CHANGED = 1;
    private static final int ABLE_TO_SEND = 2;
    private static final int IO_WORK = 4;
    private int _flags = 0;
    private int _transportFlags = 0;
    private TransportDelivery _transportDelivery;
    private byte[] _data;
    private int _dataSize;
    private boolean _complete;
    private boolean _updated;
    private boolean _done;
    private int _offset;

    DeliveryImpl(byte[] tag, LinkImpl link, DeliveryImpl previous) {
        this._tag = tag;
        this._link = link;
        this._link.incrementUnsettled();
        this._linkPrevious = previous;
        if (previous != null) {
            previous._linkNext = this;
        }
    }

    public byte[] getTag() {
        return this._tag;
    }

    public LinkImpl getLink() {
        return this._link;
    }

    public DeliveryState getLocalState() {
        return this._deliveryState;
    }

    public DeliveryState getRemoteState() {
        return this._remoteDeliveryState;
    }

    public boolean remotelySettled() {
        return this._remoteSettled;
    }

    public int getMessageFormat() {
        return 0;
    }

    public void disposition(DeliveryState state) {
        this._deliveryState = state;
        if (!this._remoteSettled) {
            this.setTransportFlag(1);
        }
    }

    public void settle() {
        this._settled = true;
        this._link.decrementUnsettled();
        if (!this._remoteSettled) {
            this.setTransportFlag(1);
        } else {
            this._transportDelivery.settled();
        }
        if (this._link.current() == this) {
            this._link.advance();
        }
        this._link.remove(this);
        if (this._linkPrevious != null) {
            this._linkPrevious._linkNext = this._linkNext;
        }
        if (this._linkNext != null) {
            this._linkNext._linkPrevious = this._linkPrevious;
        }
        this.clearWork();
    }

    DeliveryImpl getLinkNext() {
        return this._linkNext;
    }

    public void free() {
    }

    DeliveryImpl getLinkPrevious() {
        return this._linkPrevious;
    }

    public DeliveryImpl getWorkNext() {
        return this._workNext;
    }

    DeliveryImpl getWorkPrev() {
        return this._workPrev;
    }

    void setWorkNext(DeliveryImpl workNext) {
        this._workNext = workNext;
    }

    void setWorkPrev(DeliveryImpl workPrev) {
        this._workPrev = workPrev;
    }

    int recv(byte[] bytes, int offset, int size) {
        int consumed;
        if (this._data != null) {
            consumed = Math.min(size, this._dataSize);
            System.arraycopy(this._data, this._offset, bytes, offset, consumed);
            this._offset += consumed;
            this._dataSize -= consumed;
        } else {
            consumed = 0;
            this._dataSize = 0;
        }
        if (this._dataSize == 0) {
            this.clearFlag(4);
        }
        return this._complete && consumed == 0 ? -1 : consumed;
    }

    private void clearFlag(int ioWork) {
        this._flags &= 0xFFFFFFFB;
        if (this._flags == 0) {
            this.clearWork();
        }
    }

    void clearWork() {
        this.getLink().getConnectionImpl().removeWork(this);
        if (this._workPrev != null) {
            this._workPrev.setWorkNext(this._workNext);
        }
        if (this._workNext != null) {
            this._workNext.setWorkPrev(this._workPrev);
        }
        this._workPrev = null;
    }

    void addToWorkList() {
        this.getLink().getConnectionImpl().addWork(this);
    }

    void addIOWork() {
        this.setFlag(4);
    }

    private void setFlag(int flag) {
        boolean addWork;
        if (flag == 4 && (this._flags & flag) == 0) {
            this.clearWork();
            addWork = true;
        } else {
            addWork = this._flags == 0;
        }
        this._flags |= flag;
        if (addWork) {
            this.addToWorkList();
        }
    }

    private void clearTransportFlag(int ioWork) {
        this._flags &= 0xFFFFFFFB;
        if (this._flags == 0) {
            this.clearTransportWork();
        }
    }

    DeliveryImpl clearTransportWork() {
        DeliveryImpl next = this._transportWorkNext;
        this.getLink().getConnectionImpl().removeTransportWork(this);
        if (this._transportWorkPrev != null) {
            this._transportWorkPrev.setTransportWorkNext(this._transportWorkNext);
        }
        if (this._transportWorkNext != null) {
            this._transportWorkNext.setTransportWorkPrev(this._transportWorkPrev);
        }
        this._transportWorkNext = null;
        this._transportWorkPrev = null;
        return next;
    }

    void addToTransportWorkList() {
        if (this._transportWorkNext == null && this._transportWorkPrev == null && this.getLink().getConnectionImpl().getTransportWorkHead() != this) {
            this.getLink().getConnectionImpl().addTransportWork(this);
        }
    }

    private void setTransportFlag(int flag) {
        boolean addWork = this._transportFlags == 0;
        this._transportFlags |= flag;
        if (addWork) {
            this.addToTransportWorkList();
        }
    }

    DeliveryImpl getTransportWorkNext() {
        return this._transportWorkNext;
    }

    DeliveryImpl getTransportWorkPrev() {
        return this._transportWorkPrev;
    }

    void setTransportWorkNext(DeliveryImpl transportWorkNext) {
        this._transportWorkNext = transportWorkNext;
    }

    void setTransportWorkPrev(DeliveryImpl transportWorkPrev) {
        this._transportWorkPrev = transportWorkPrev;
    }

    boolean isLocalStateChange() {
        return (this._transportFlags & 1) != 0;
    }

    TransportDelivery getTransportDelivery() {
        return this._transportDelivery;
    }

    void setTransportDelivery(TransportDelivery transportDelivery) {
        this._transportDelivery = transportDelivery;
    }

    public boolean isSettled() {
        return this._settled;
    }

    int send(byte[] bytes, int offset, int length) {
        if (this._data == null) {
            this._data = new byte[length];
        } else if (this._data.length - this._dataSize < length) {
            byte[] oldData = this._data;
            this._data = new byte[oldData.length + this._dataSize];
            System.arraycopy(oldData, this._offset, this._data, 0, this._dataSize);
            this._offset = 0;
        }
        System.arraycopy(bytes, offset, this._data, this._dataSize + this._offset, length);
        this._dataSize += length;
        this.addToTransportWorkList();
        return length;
    }

    byte[] getData() {
        return this._data;
    }

    int getDataOffset() {
        return this._offset;
    }

    int getDataLength() {
        return this._dataSize;
    }

    void setData(byte[] data) {
        this._data = data;
    }

    void setDataLength(int length) {
        this._dataSize = length;
    }

    public void setDataOffset(int arrayOffset) {
        this._offset = arrayOffset;
    }

    public boolean isWritable() {
        return this.getLink() instanceof SenderImpl && this.getLink().current() == this && ((SenderImpl)this.getLink()).hasCredit();
    }

    public boolean isReadable() {
        return this.getLink() instanceof ReceiverImpl && this.getLink().current() == this && this._dataSize > 0;
    }

    void setComplete() {
        this._complete = true;
    }

    public boolean isPartial() {
        return !this._complete;
    }

    void setRemoteDeliveryState(DeliveryState remoteDeliveryState) {
        this._remoteDeliveryState = remoteDeliveryState;
        this._updated = true;
    }

    public boolean isUpdated() {
        return this._updated;
    }

    void setDone() {
        this._done = true;
    }

    boolean isDone() {
        return this._done;
    }

    void setRemoteSettled(boolean remoteSettled) {
        this._remoteSettled = remoteSettled;
        this._updated = true;
    }

    public Object getContext() {
        return this._context;
    }

    public void setContext(Object context) {
        this._context = context;
    }
}

