/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jsf.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.jsf.deployment.JSFModuleIdFactory;
import org.jboss.as.jsf.deployment.JsfVersionMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.common.SharedTldsMetaDataBuilder;
import org.jboss.metadata.parser.jsp.TldMetaDataParser;
import org.jboss.metadata.parser.util.NoopXMLResolver;
import org.jboss.metadata.web.spec.TldMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;

public class JSFSharedTldsProcessor
implements DeploymentUnitProcessor {
    private static final String[] JSF_TAGLIBS = new String[]{"html_basic.tld", "jsf_core.tld", "mojarra_ext.tld", "myfaces_core.tld", "myfaces_html.tld"};
    private final Map<String, List<TldMetaData>> jsfTldMap = new HashMap<String, List<TldMetaData>>();

    public JSFSharedTldsProcessor() {
        this.init();
    }

    private void init() {
        JSFModuleIdFactory moduleFactory = JSFModuleIdFactory.getInstance();
        List<String> jsfSlotNames = moduleFactory.getActiveJSFVersions();
        for (String slot : jsfSlotNames) {
            ArrayList<TldMetaData> jsfTlds = new ArrayList<TldMetaData>();
            try {
                ModuleClassLoader jsf = Module.getModuleFromCallerModuleLoader((ModuleIdentifier)moduleFactory.getImplModId(slot)).getClassLoader();
                for (String tld : JSF_TAGLIBS) {
                    InputStream is = jsf.getResourceAsStream("META-INF/" + tld);
                    if (is == null) continue;
                    TldMetaData tldMetaData = this.parseTLD(is);
                    jsfTlds.add(tldMetaData);
                }
            }
            catch (ModuleLoadException e) {
            }
            catch (Exception e) {
                // empty catch block
            }
            this.jsfTldMap.put(slot, jsfTlds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TldMetaData parseTLD(InputStream is) throws Exception {
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setXMLResolver(NoopXMLResolver.create());
            XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(is);
            TldMetaData tldMetaData = TldMetaDataParser.parse((XMLStreamReader)xmlReader);
            return tldMetaData;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        List<TldMetaData> jsfTlds;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentUnit topLevelDeployment = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        String jsfVersion = JsfVersionMarker.getVersion(topLevelDeployment);
        if (jsfVersion.equals("WAR_BUNDLES_JSF_IMPL")) {
            return;
        }
        ArrayList<TldMetaData> tldsMetaData = (ArrayList<TldMetaData>)deploymentUnit.getAttachment(SharedTldsMetaDataBuilder.ATTACHMENT_KEY);
        if (tldsMetaData == null) {
            tldsMetaData = new ArrayList<TldMetaData>();
        }
        String slot = jsfVersion;
        if (!JSFModuleIdFactory.getInstance().isValidJSFSlot(slot)) {
            slot = JSFModuleIdFactory.getInstance().getDefaultSlot();
        }
        if ((jsfTlds = this.jsfTldMap.get(slot = JSFModuleIdFactory.getInstance().computeSlot(slot))) != null) {
            tldsMetaData.addAll(jsfTlds);
        }
        deploymentUnit.putAttachment(SharedTldsMetaDataBuilder.ATTACHMENT_KEY, tldsMetaData);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

