/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.as.messaging.jms.AbstractUpdateJndiHandler;
import org.jboss.as.messaging.jms.JMSTopicAdd;
import org.jboss.as.messaging.jms.JMSTopicConfigurationRuntimeHandler;
import org.jboss.as.messaging.jms.JMSTopicConfigurationWriteHandler;
import org.jboss.as.messaging.jms.JMSTopicControlHandler;
import org.jboss.as.messaging.jms.JMSTopicReadAttributeHandler;
import org.jboss.as.messaging.jms.JMSTopicRemove;
import org.jboss.as.messaging.jms.JMSTopicUpdateJndiHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class JMSTopicDefinition
extends SimpleResourceDefinition {
    public static final PathElement PATH = PathElement.pathElement((String)"jms-topic");
    public static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.DESTINATION_ENTRIES};
    static final AttributeDefinition TOPIC_ADDRESS = SimpleAttributeDefinitionBuilder.create((String)"topic-address", (ModelType)ModelType.STRING).setStorageRuntime().build();
    static final AttributeDefinition[] READONLY_ATTRIBUTES = new AttributeDefinition[]{TOPIC_ADDRESS, CommonAttributes.TEMPORARY};
    static final AttributeDefinition DURABLE_MESSAGE_COUNT = SimpleAttributeDefinitionBuilder.create((String)"durable-message-count", (ModelType)ModelType.INT).setStorageRuntime().build();
    static final AttributeDefinition NON_DURABLE_MESSAGE_COUNT = SimpleAttributeDefinitionBuilder.create((String)"non-durable-message-count", (ModelType)ModelType.INT).setStorageRuntime().build();
    static final AttributeDefinition SUBSCRIPTION_COUNT = SimpleAttributeDefinitionBuilder.create((String)"subscription-count", (ModelType)ModelType.INT).setStorageRuntime().build();
    static final AttributeDefinition DURABLE_SUBSCRIPTION_COUNT = SimpleAttributeDefinitionBuilder.create((String)"durable-subscription-count", (ModelType)ModelType.INT).setStorageRuntime().build();
    static final AttributeDefinition NON_DURABLE_SUBSCRIPTION_COUNT = SimpleAttributeDefinitionBuilder.create((String)"non-durable-subscription-count", (ModelType)ModelType.INT).setStorageRuntime().build();
    static final AttributeDefinition[] METRICS = new AttributeDefinition[]{CommonAttributes.DELIVERING_COUNT, CommonAttributes.MESSAGES_ADDED, CommonAttributes.MESSAGE_COUNT, DURABLE_MESSAGE_COUNT, NON_DURABLE_MESSAGE_COUNT, SUBSCRIPTION_COUNT, DURABLE_SUBSCRIPTION_COUNT, NON_DURABLE_SUBSCRIPTION_COUNT};
    public static final String REMOVE_MESSAGES = "remove-messages";
    public static final String DROP_ALL_SUBSCRIPTIONS = "drop-all-subscriptions";
    public static final String DROP_DURABLE_SUBSCRIPTION = "drop-durable-subscription";
    public static final String SUBSCRIPTION_NAME = "subscription-name";
    public static final String COUNT_MESSAGES_FOR_SUBSCRIPTION = "count-messages-for-subscription";
    public static final String LIST_MESSAGES_FOR_SUBSCRIPTION_AS_JSON = "list-messages-for-subscription-as-json";
    public static final String LIST_MESSAGES_FOR_SUBSCRIPTION = "list-messages-for-subscription";
    public static final String LIST_NON_DURABLE_SUBSCRIPTIONS_AS_JSON = "list-non-durable-subscriptions-as-json";
    public static final String LIST_NON_DURABLE_SUBSCRIPTIONS = "list-non-durable-subscriptions";
    public static final String LIST_DURABLE_SUBSCRIPTIONS_AS_JSON = "list-durable-subscriptions-as-json";
    public static final String LIST_DURABLE_SUBSCRIPTIONS = "list-durable-subscriptions";
    public static final String LIST_ALL_SUBSCRIPTIONS_AS_JSON = "list-all-subscriptions-as-json";
    public static final String LIST_ALL_SUBSCRIPTIONS = "list-all-subscriptions";
    private final boolean registerRuntimeOnly;
    private final boolean deployed;
    private final List<AccessConstraintDefinition> accessConstraints;

    private static AttributeDefinition[] getDeploymentAttributes() {
        return new AttributeDefinition[]{((PrimitiveListAttributeDefinition.Builder)new PrimitiveListAttributeDefinition.Builder(CommonAttributes.DESTINATION_ENTRIES).setStorageRuntime()).build()};
    }

    public static JMSTopicDefinition newDeployedJMSTopicDefinition() {
        return new JMSTopicDefinition(true, true, null, null);
    }

    public JMSTopicDefinition(boolean registerRuntimeOnly) {
        this(registerRuntimeOnly, false, (OperationStepHandler)JMSTopicAdd.INSTANCE, (OperationStepHandler)JMSTopicRemove.INSTANCE);
    }

    private JMSTopicDefinition(boolean registerRuntimeOnly, boolean deployed, OperationStepHandler addHandler, OperationStepHandler removeHandler) {
        super(PATH, MessagingExtension.getResourceDescriptionResolver("jms-topic"), addHandler, removeHandler);
        this.registerRuntimeOnly = registerRuntimeOnly;
        this.deployed = deployed;
        ApplicationTypeConfig atc = new ApplicationTypeConfig("messaging", "jms-topic");
        this.accessConstraints = new ApplicationTypeAccessConstraintDefinition(atc).wrapAsList();
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        AttributeDefinition[] attributes;
        super.registerAttributes(registry);
        for (AttributeDefinition attr : attributes = this.deployed ? JMSTopicDefinition.getDeploymentAttributes() : ATTRIBUTES) {
            if (!this.registerRuntimeOnly && attr.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME)) continue;
            if (this.deployed) {
                registry.registerReadOnlyAttribute(attr, (OperationStepHandler)JMSTopicConfigurationRuntimeHandler.INSTANCE);
                continue;
            }
            registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)JMSTopicConfigurationWriteHandler.INSTANCE);
        }
        if (this.registerRuntimeOnly) {
            for (AttributeDefinition attr : READONLY_ATTRIBUTES) {
                registry.registerReadOnlyAttribute(attr, (OperationStepHandler)JMSTopicReadAttributeHandler.INSTANCE);
            }
            for (AttributeDefinition metric : METRICS) {
                registry.registerMetric(metric, (OperationStepHandler)JMSTopicReadAttributeHandler.INSTANCE);
            }
        }
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        super.registerOperations(registry);
        if (this.registerRuntimeOnly && !this.deployed) {
            SimpleOperationDefinition add = new SimpleOperationDefinition("add-jndi", this.getResourceDescriptionResolver(), new AttributeDefinition[]{AbstractUpdateJndiHandler.JNDI_BINDING});
            registry.registerOperationHandler((OperationDefinition)add, (OperationStepHandler)new JMSTopicUpdateJndiHandler(true));
            SimpleOperationDefinition remove = new SimpleOperationDefinition("remove-jndi", this.getResourceDescriptionResolver(), new AttributeDefinition[]{AbstractUpdateJndiHandler.JNDI_BINDING});
            registry.registerOperationHandler((OperationDefinition)remove, (OperationStepHandler)new JMSTopicUpdateJndiHandler(false));
        }
        EnumSet<OperationEntry.Flag> readOnly = EnumSet.of(OperationEntry.Flag.READ_ONLY, OperationEntry.Flag.RUNTIME_ONLY);
        EnumSet<OperationEntry.Flag> runtimeOnly = EnumSet.of(OperationEntry.Flag.RUNTIME_ONLY);
        registry.registerOperationHandler(LIST_ALL_SUBSCRIPTIONS, (OperationStepHandler)JMSTopicControlHandler.INSTANCE, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getListSubscriptionsOperation(locale, JMSTopicDefinition.LIST_ALL_SUBSCRIPTIONS);
            }
        }, readOnly);
        registry.registerOperationHandler(LIST_ALL_SUBSCRIPTIONS_AS_JSON, (OperationStepHandler)JMSTopicControlHandler.INSTANCE, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleReplyOperation(locale, JMSTopicDefinition.LIST_ALL_SUBSCRIPTIONS_AS_JSON, "jms-topic", ModelType.STRING, false);
            }
        }, readOnly);
        registry.registerOperationHandler(LIST_DURABLE_SUBSCRIPTIONS, (OperationStepHandler)JMSTopicControlHandler.INSTANCE, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getListSubscriptionsOperation(locale, JMSTopicDefinition.LIST_DURABLE_SUBSCRIPTIONS);
            }
        }, readOnly);
        registry.registerOperationHandler(LIST_DURABLE_SUBSCRIPTIONS_AS_JSON, (OperationStepHandler)JMSTopicControlHandler.INSTANCE, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleReplyOperation(locale, JMSTopicDefinition.LIST_DURABLE_SUBSCRIPTIONS_AS_JSON, "jms-topic", ModelType.STRING, false);
            }
        }, readOnly);
        registry.registerOperationHandler(LIST_NON_DURABLE_SUBSCRIPTIONS, (OperationStepHandler)JMSTopicControlHandler.INSTANCE, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getListSubscriptionsOperation(locale, JMSTopicDefinition.LIST_NON_DURABLE_SUBSCRIPTIONS);
            }
        }, readOnly);
        registry.registerOperationHandler(LIST_NON_DURABLE_SUBSCRIPTIONS_AS_JSON, (OperationStepHandler)JMSTopicControlHandler.INSTANCE, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleReplyOperation(locale, JMSTopicDefinition.LIST_NON_DURABLE_SUBSCRIPTIONS_AS_JSON, "jms-topic", ModelType.STRING, false);
            }
        }, readOnly);
        registry.registerOperationHandler(LIST_MESSAGES_FOR_SUBSCRIPTION, (OperationStepHandler)JMSTopicControlHandler.INSTANCE, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getListMessagesForSubscription(locale);
            }
        }, readOnly);
        registry.registerOperationHandler(LIST_MESSAGES_FOR_SUBSCRIPTION_AS_JSON, (OperationStepHandler)JMSTopicControlHandler.INSTANCE, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getListMessagesForSubscriptionAsJSON(locale);
            }
        }, readOnly);
        registry.registerOperationHandler(COUNT_MESSAGES_FOR_SUBSCRIPTION, (OperationStepHandler)JMSTopicControlHandler.INSTANCE, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getCountMessagesForSubscription(locale);
            }
        }, readOnly);
        registry.registerOperationHandler(DROP_DURABLE_SUBSCRIPTION, (OperationStepHandler)JMSTopicControlHandler.INSTANCE, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getDropDurableSubscription(locale);
            }
        }, runtimeOnly);
        registry.registerOperationHandler(DROP_ALL_SUBSCRIPTIONS, (OperationStepHandler)JMSTopicControlHandler.INSTANCE, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getDescriptionOnlyOperation(locale, JMSTopicDefinition.DROP_ALL_SUBSCRIPTIONS, "jms-topic");
            }
        }, runtimeOnly);
        registry.registerOperationHandler(REMOVE_MESSAGES, (OperationStepHandler)JMSTopicControlHandler.INSTANCE, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getRemoveMessages(locale);
            }
        }, runtimeOnly);
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }
}

