/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.provider;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.infinispan.Cache;
import org.jboss.as.clustering.infinispan.invoker.BatchCacheInvoker;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.infinispan.subsystem.CacheServiceProvider;
import org.jboss.as.clustering.jgroups.subsystem.ChannelServiceProvider;
import org.jboss.as.clustering.msc.AsynchronousService;
import org.jboss.as.clustering.naming.JndiNameFactory;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.provider.ServiceProviderRegistrationFactory;
import org.wildfly.clustering.server.dispatcher.CommandDispatcherFactoryProvider;
import org.wildfly.clustering.server.group.CacheGroupProvider;
import org.wildfly.clustering.server.provider.ServiceProviderRegistrationFactoryConfiguration;
import org.wildfly.clustering.server.provider.ServiceProviderRegistrationFactoryService;

public class ServiceProviderRegistrationFactoryProvider
implements CacheServiceProvider {
    private static final Logger logger = Logger.getLogger(ChannelServiceProvider.class);

    public static ServiceName getServiceName(String containerName, String cacheName) {
        return ServiceName.JBOSS.append(new String[]{"clustering", "providers", containerName, cacheName});
    }

    private static ContextNames.BindInfo createBinding(String containerName, String cacheName) {
        return ContextNames.bindInfoFor((String)JndiNameFactory.createJndiName((String)"java:jboss", (String[])new String[]{"clustering", "providers", containerName, cacheName}).getAbsoluteName());
    }

    public Collection<ServiceName> getServiceNames(String containerName, String cacheName, boolean defaultCache) {
        return Arrays.asList(ServiceProviderRegistrationFactoryProvider.getServiceName(containerName, cacheName), ServiceProviderRegistrationFactoryProvider.createBinding(containerName, cacheName).getBinderServiceName());
    }

    public Collection<ServiceController<?>> install(ServiceTarget target, String containerName, String cacheName, boolean defaultCache, ModuleIdentifier moduleId) {
        ServiceName name = ServiceProviderRegistrationFactoryProvider.getServiceName(containerName, cacheName);
        ContextNames.BindInfo bindInfo = ServiceProviderRegistrationFactoryProvider.createBinding(containerName, cacheName);
        logger.debugf("Installing %s service, bound to ", (Object)name.getCanonicalName(), (Object)bindInfo.getAbsoluteJndiName());
        ServiceProviderRegistrationFactoryConfig config = new ServiceProviderRegistrationFactoryConfig(name);
        ServiceProviderRegistrationFactoryService service = new ServiceProviderRegistrationFactoryService(config);
        ServiceBuilder builder = AsynchronousService.addService((ServiceTarget)target, (ServiceName)name, (Service)service).addDependency(CacheService.getServiceName((String)containerName, (String)cacheName), Cache.class, config.getCacheInjector()).addDependency(CacheGroupProvider.getServiceName(containerName, cacheName), Group.class, config.getGroupInjector()).addDependency(CommandDispatcherFactoryProvider.getServiceName(containerName), CommandDispatcherFactory.class, config.getCommandDispatcherFactoryInjector()).setInitialMode(ServiceController.Mode.ON_DEMAND);
        BinderService binder = new BinderService(bindInfo.getBindName());
        ServiceBuilder binderBuilder = target.addService(bindInfo.getBinderServiceName(), (Service)binder).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{bindInfo.getBindName()})}).addDependency(name, ServiceProviderRegistrationFactory.class, (Injector)new ManagedReferenceInjector((Injector)binder.getManagedObjectInjector())).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binder.getNamingStoreInjector()).setInitialMode(ServiceController.Mode.PASSIVE);
        if (defaultCache) {
            ContextNames.BindInfo info = ServiceProviderRegistrationFactoryProvider.createBinding(containerName, "default");
            binderBuilder.addAliases(new ServiceName[]{info.getBinderServiceName(), ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{info.getBindName()})});
            builder.addAliases(new ServiceName[]{ServiceProviderRegistrationFactoryProvider.getServiceName(containerName, "default")});
        }
        return Arrays.asList(builder.install(), binderBuilder.install());
    }

    private static class ServiceProviderRegistrationFactoryConfig
    implements ServiceProviderRegistrationFactoryConfiguration {
        private final InjectedValue<Group> group = new InjectedValue();
        private final InjectedValue<Cache<Object, Set<Node>>> cache = new InjectedValue();
        private final InjectedValue<CommandDispatcherFactory> factory = new InjectedValue();
        private final Object id;
        private final CacheInvoker invoker = new BatchCacheInvoker();

        ServiceProviderRegistrationFactoryConfig(Object id) {
            this.id = id;
        }

        @Override
        public Object getId() {
            return this.id;
        }

        @Override
        public Group getGroup() {
            return (Group)this.group.getValue();
        }

        @Override
        public Cache<Object, Set<Node>> getCache() {
            return (Cache)this.cache.getValue();
        }

        @Override
        public CommandDispatcherFactory getCommandDispatcherFactory() {
            return (CommandDispatcherFactory)this.factory.getValue();
        }

        @Override
        public CacheInvoker getCacheInvoker() {
            return this.invoker;
        }

        Injector<Group> getGroupInjector() {
            return this.group;
        }

        Injector<Cache> getCacheInjector() {
            return this.cache;
        }

        Injector<CommandDispatcherFactory> getCommandDispatcherFactoryInjector() {
            return this.factory;
        }
    }
}

