/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.registry;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.group.NodeFactory;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.registry.RegistryEntryProvider;
import org.wildfly.clustering.registry.RegistryFactory;
import org.wildfly.clustering.server.registry.RegistryFactoryConfiguration;

@Listener
public class RegistryFactoryService<K, V>
implements RegistryFactory<K, V>,
Service<RegistryFactory<K, V>>,
Registry<K, V> {
    private final List<Registry.Listener<K, V>> listeners = new CopyOnWriteArrayList<Registry.Listener<K, V>>();
    private final AtomicReference<RegistryEntryProvider<K, V>> provider = new AtomicReference();
    private final RegistryFactoryConfiguration<K, V> config;
    private volatile CacheInvoker invoker = null;
    private volatile Group group = null;
    private volatile Cache<Node, Map.Entry<K, V>> cache = null;
    private volatile NodeFactory<Address> factory = null;

    public RegistryFactoryService(RegistryFactoryConfiguration<K, V> config) {
        this.config = config;
    }

    public RegistryFactory<K, V> getValue() {
        return this;
    }

    public void start(StartContext context) {
        this.invoker = this.config.getCacheInvoker();
        this.group = this.config.getGroup();
        this.cache = this.config.getCache();
        this.factory = this.config.getNodeFactory();
    }

    public void stop(StopContext context) {
        this.close();
        this.cache = null;
    }

    public Registry<K, V> createRegistry(RegistryEntryProvider<K, V> provider) {
        if (!this.provider.compareAndSet(null, provider)) {
            throw new IllegalStateException();
        }
        this.getLocalEntry();
        this.cache.addListener((Object)this);
        return this;
    }

    public void close() {
        if (this.provider.getAndSet(null) != null) {
            this.cache.removeListener((Object)this);
            this.listeners.clear();
            final Node node = this.group.getLocalNode();
            Operation<Void> operation = new Operation<Void>(){

                public Void invoke(Cache<Node, Map.Entry<K, V>> cache) {
                    cache.remove((Object)node);
                    return null;
                }
            };
            this.invoker.invoke(this.cache, (CacheInvoker.Operation)operation, new Flag[]{Flag.IGNORE_RETURN_VALUES});
        }
    }

    public void addListener(Registry.Listener<K, V> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Registry.Listener<K, V> listener) {
        this.listeners.remove(listener);
    }

    public Group getGroup() {
        return this.group;
    }

    public Map<K, V> getEntries() {
        HashMap map = new HashMap();
        for (Node node : this.cache.keySet()) {
            Map.Entry entry = (Map.Entry)this.cache.get((Object)node);
            if (entry == null) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(map);
    }

    public Map.Entry<K, V> getEntry(Node node) {
        return (Map.Entry)this.cache.get((Object)node);
    }

    public Map.Entry<K, V> getLocalEntry() {
        AbstractMap.SimpleImmutableEntry<Object, Object> entry;
        RegistryEntryProvider<K, V> provider = this.provider.get();
        if (provider == null) {
            return null;
        }
        Object key = provider.getKey();
        AbstractMap.SimpleImmutableEntry<Object, Object> simpleImmutableEntry = entry = key != null ? new AbstractMap.SimpleImmutableEntry<Object, Object>(key, provider.getValue()) : null;
        if (entry != null) {
            final Node node = this.group.getLocalNode();
            Operation<Void> operation = new Operation<Void>(){

                public Void invoke(Cache<Node, Map.Entry<K, V>> cache) {
                    cache.put((Object)node, (Object)entry);
                    return null;
                }
            };
            this.invoker.invoke(this.cache, (CacheInvoker.Operation)operation, new Flag[]{Flag.IGNORE_RETURN_VALUES});
        }
        return entry;
    }

    @TopologyChanged
    public void topologyChanged(TopologyChangedEvent<Address, Node> event) {
        if (event.isPre()) {
            return;
        }
        List newAddresses = event.getConsistentHashAtEnd().getMembers();
        if (!((Address)newAddresses.get(0)).equals(event.getCache().getCacheManager().getAddress())) {
            return;
        }
        HashSet addresses = new HashSet(event.getConsistentHashAtStart().getMembers());
        addresses.removeAll(newAddresses);
        final ArrayList<Node> nodes = new ArrayList<Node>(addresses.size());
        for (Address address : addresses) {
            nodes.add(this.factory.createNode((Object)address));
        }
        Operation operation = new Operation<Map<K, V>>(){

            public Map<K, V> invoke(Cache<Node, Map.Entry<K, V>> cache) {
                HashMap removed = new HashMap();
                for (Node node : nodes) {
                    Map.Entry old = (Map.Entry)cache.remove((Object)node);
                    if (old == null) continue;
                    removed.put(old.getKey(), old.getValue());
                }
                return removed;
            }
        };
        Map removed = (Map)this.invoker.invoke(this.cache, (CacheInvoker.Operation)operation, new Flag[0]);
        if (!removed.isEmpty()) {
            for (Registry.Listener<K, V> listener : this.listeners) {
                listener.removedEntries(removed);
            }
        }
    }

    @CacheEntryModified
    public void modified(CacheEntryModifiedEvent<Node, Map.Entry<K, V>> event) {
        Map.Entry entry;
        if (event.isOriginLocal() || event.isPre()) {
            return;
        }
        if (!this.listeners.isEmpty() && (entry = (Map.Entry)event.getValue()) != null) {
            Map entries = Collections.singletonMap(entry.getKey(), entry.getValue());
            for (Registry.Listener<K, V> listener : this.listeners) {
                if (event.isCreated()) {
                    listener.addedEntries(entries);
                    continue;
                }
                listener.updatedEntries(entries);
            }
        }
    }

    @CacheEntryRemoved
    public void removed(CacheEntryRemovedEvent<Node, Map.Entry<K, V>> event) {
        if (event.isOriginLocal() || event.isPre()) {
            return;
        }
        Map.Entry entry = (Map.Entry)event.getOldValue();
        if (entry != null) {
            Map entries = Collections.singletonMap(entry.getKey(), entry.getValue());
            for (Registry.Listener<K, V> listener : this.listeners) {
                listener.removedEntries(entries);
            }
        }
    }

    abstract class Operation<R>
    implements CacheInvoker.Operation<Node, Map.Entry<K, V>, R> {
        Operation() {
        }
    }
}

