/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.internal.util.propertyservice;

import com.arjuna.common.internal.util.propertyservice.ConcatenationPrefix;
import com.arjuna.common.internal.util.propertyservice.FullPropertyName;
import com.arjuna.common.internal.util.propertyservice.PropertyPrefix;
import com.arjuna.common.util.propertyservice.PropertiesFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class BeanPopulator {
    private static final ConcurrentMap<String, Object> beanInstances = new ConcurrentHashMap<String, Object>();
    private static final String DEFAULT_NAME = "default";

    public static <T> T getDefaultInstance(Class<T> beanClass) throws RuntimeException {
        return BeanPopulator.getNamedInstance(beanClass, DEFAULT_NAME, null);
    }

    @Deprecated
    public static <T> T getDefaultInstance(Class<T> beanClass, Properties properties) throws RuntimeException {
        return BeanPopulator.getNamedInstance(beanClass, DEFAULT_NAME, properties);
    }

    public static <T> T getNamedInstance(Class<T> beanClass, String name) throws RuntimeException {
        return BeanPopulator.getNamedInstance(beanClass, name, null);
    }

    private static <T> T getNamedInstance(Class<T> beanClass, String name, Properties properties) throws RuntimeException {
        String key;
        if (name == null) {
            name = DEFAULT_NAME;
        }
        if (!beanInstances.containsKey(key = beanClass.getName() + ":" + name)) {
            Object bean = null;
            try {
                bean = beanClass.newInstance();
                if (properties != null) {
                    BeanPopulator.configureFromProperties(bean, name, properties);
                } else {
                    Properties defaultProperties = PropertiesFactory.getDefaultProperties();
                    BeanPopulator.configureFromProperties(bean, name, defaultProperties);
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            beanInstances.putIfAbsent(key, bean);
        }
        return (T)beanInstances.get(key);
    }

    public static void configureFromProperties(Object bean, Properties properties) throws Exception {
        BeanPopulator.configureFromProperties(bean, DEFAULT_NAME, properties);
    }

    public static void configureFromProperties(Object bean, String instanceName, Properties properties) throws Exception {
        for (Field field : bean.getClass().getDeclaredFields()) {
            String getterMethodName;
            Method setter;
            Class<?> type = field.getType();
            String setterMethodName = "set" + BeanPopulator.capitalizeFirstLetter(field.getName());
            try {
                setter = bean.getClass().getMethod(setterMethodName, field.getType());
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            Method getter = null;
            if (field.getType().equals(Boolean.TYPE)) {
                getterMethodName = "is" + BeanPopulator.capitalizeFirstLetter(field.getName());
                try {
                    getter = bean.getClass().getMethod(getterMethodName, new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            if (getter == null) {
                getterMethodName = "get" + BeanPopulator.capitalizeFirstLetter(field.getName());
                getter = bean.getClass().getMethod(getterMethodName, new Class[0]);
            }
            if (field.isAnnotationPresent(ConcatenationPrefix.class) || field.getType().getName().startsWith("java.util")) {
                BeanPopulator.handleGroupProperty(bean, instanceName, properties, field, setter, getter);
                continue;
            }
            BeanPopulator.handleSimpleProperty(bean, instanceName, properties, field, setter, getter);
        }
    }

    public static String printBean(Object bean) {
        StringBuffer buffer = new StringBuffer();
        BeanPopulator.printBean(bean, buffer);
        return buffer.toString();
    }

    public static String printState() {
        StringBuffer buffer = new StringBuffer();
        for (Object bean : beanInstances.values()) {
            BeanPopulator.printBean(bean, buffer);
        }
        return buffer.toString();
    }

    private static void handleGroupProperty(Object bean, String instanceName, Properties properties, Field field, Method setter, Method getter) throws Exception {
        LinkedList<String> lines = new LinkedList<String>();
        String valueFromProperties = BeanPopulator.getValueFromProperties(bean, instanceName, properties, field, bean.getClass().getSimpleName());
        if (valueFromProperties != null) {
            String[] tokens;
            for (String token : tokens = valueFromProperties.split("\\s+")) {
                lines.add(token);
            }
        } else {
            LinkedList<String> listOfMatchingPropertyNames = new LinkedList<String>();
            Enumeration<?> propertyNamesEnumeration = properties.propertyNames();
            ConcatenationPrefix concatenationPrefix = field.getAnnotation(ConcatenationPrefix.class);
            if (propertyNamesEnumeration != null && concatenationPrefix != null) {
                String prefix = concatenationPrefix.prefix();
                while (propertyNamesEnumeration.hasMoreElements()) {
                    String name = (String)propertyNamesEnumeration.nextElement();
                    if (!name.startsWith(prefix)) continue;
                    listOfMatchingPropertyNames.add(name);
                }
            }
            Collections.sort(listOfMatchingPropertyNames);
            for (String name : listOfMatchingPropertyNames) {
                String value = properties.getProperty(name);
                lines.add(value);
            }
            if (lines.size() == 0) {
                return;
            }
        }
        Cloneable replacementValue = null;
        if (Map.class.isAssignableFrom(field.getType())) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (String element : lines) {
                String[] tokens = element.split("=");
                map.put(tokens[0], tokens[1]);
            }
            replacementValue = map;
        } else {
            replacementValue = lines;
        }
        Object valueFromBean = getter.invoke(bean, new Object[0]);
        if (!valueFromBean.equals(replacementValue)) {
            setter.invoke(bean, replacementValue);
        }
    }

    private static void handleSimpleProperty(Object bean, String instanceName, Properties properties, Field field, Method setter, Method getter) throws Exception {
        String valueFromProperties;
        String prefix = null;
        if (bean.getClass().isAnnotationPresent(PropertyPrefix.class)) {
            PropertyPrefix prefixAnnotation = bean.getClass().getAnnotation(PropertyPrefix.class);
            prefix = prefixAnnotation.prefix();
        }
        if ((valueFromProperties = BeanPopulator.getValueFromProperties(bean, instanceName, properties, field, prefix)) != null) {
            Object valueFromBean = getter.invoke(bean, new Object[0]);
            if (field.getType().equals(Boolean.TYPE)) {
                if (!((Boolean)valueFromBean).booleanValue() && BeanPopulator.isPositive(valueFromProperties)) {
                    setter.invoke(bean, Boolean.TRUE);
                }
                if (((Boolean)valueFromBean).booleanValue() && BeanPopulator.isNegative(valueFromProperties)) {
                    setter.invoke(bean, Boolean.FALSE);
                }
            } else if (field.getType().equals(String.class)) {
                if (!valueFromProperties.equals(valueFromBean)) {
                    setter.invoke(bean, valueFromProperties);
                }
            } else if (field.getType().equals(Long.TYPE)) {
                Long longValue = Long.valueOf(valueFromProperties);
                if (!longValue.equals(valueFromBean)) {
                    setter.invoke(bean, longValue);
                }
            } else if (field.getType().equals(Integer.TYPE)) {
                Integer intValue = Integer.valueOf(valueFromProperties);
                if (!intValue.equals(valueFromBean)) {
                    setter.invoke(bean, intValue);
                }
            } else {
                throw new Exception("unknown field type " + field.getType());
            }
        }
    }

    private static String getValueFromProperties(Object bean, String instanceName, Properties properties, Field field, String prefix) {
        String propertyFileKey;
        String valueFromProperties = null;
        if (instanceName == null) {
            instanceName = DEFAULT_NAME;
        }
        if (valueFromProperties == null) {
            if (DEFAULT_NAME.equals(instanceName)) {
                propertyFileKey = bean.getClass().getName() + "." + field.getName();
                valueFromProperties = properties.getProperty(propertyFileKey);
            }
            if (valueFromProperties == null) {
                propertyFileKey = bean.getClass().getName() + "." + instanceName + "." + field.getName();
                valueFromProperties = properties.getProperty(propertyFileKey);
            }
        }
        if (valueFromProperties == null) {
            if (DEFAULT_NAME.equals(instanceName)) {
                propertyFileKey = bean.getClass().getSimpleName() + "." + field.getName();
                valueFromProperties = properties.getProperty(propertyFileKey);
            }
            if (valueFromProperties == null) {
                propertyFileKey = bean.getClass().getSimpleName() + "." + instanceName + "." + field.getName();
                valueFromProperties = properties.getProperty(propertyFileKey);
            }
        }
        if (valueFromProperties == null) {
            if (field.isAnnotationPresent(FullPropertyName.class)) {
                FullPropertyName fullPropertyName = field.getAnnotation(FullPropertyName.class);
                propertyFileKey = fullPropertyName.name();
            } else {
                propertyFileKey = prefix != null ? prefix + field.getName() : field.getName();
            }
            valueFromProperties = properties.getProperty(propertyFileKey);
        }
        return valueFromProperties;
    }

    private static void printBean(Object bean, StringBuffer buffer) {
        String lineSeparator = System.getProperty("line.separator");
        buffer.append("Bean class: ");
        buffer.append(bean.getClass().getName());
        buffer.append(lineSeparator);
        for (Field field : bean.getClass().getDeclaredFields()) {
            String getterMethodName;
            Class<?> type = field.getType();
            Method getter = null;
            if (field.getType().equals(Boolean.TYPE)) {
                getterMethodName = "is" + BeanPopulator.capitalizeFirstLetter(field.getName());
                try {
                    getter = bean.getClass().getMethod(getterMethodName, new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            try {
                if (getter == null) {
                    getterMethodName = "get" + BeanPopulator.capitalizeFirstLetter(field.getName());
                    getter = bean.getClass().getMethod(getterMethodName, new Class[0]);
                }
                Object valueFromBean = getter.invoke(bean, new Object[0]);
                buffer.append("  ");
                buffer.append(field.getName());
                buffer.append(": ");
                buffer.append(valueFromBean);
            }
            catch (Exception e) {
                buffer.append("failed to read property ");
                buffer.append(field.getName());
            }
            buffer.append(lineSeparator);
        }
    }

    private static String capitalizeFirstLetter(String string) {
        return string.length() > 0 ? Character.toUpperCase(string.charAt(0)) + string.substring(1) : string;
    }

    private static boolean isPositive(String value) {
        return "YES".equalsIgnoreCase(value) || "ON".equalsIgnoreCase(value) || "TRUE".equalsIgnoreCase(value);
    }

    private static boolean isNegative(String value) {
        return "NO".equalsIgnoreCase(value) || "OFF".equalsIgnoreCase(value) || "FALSE".equalsIgnoreCase(value);
    }
}

