/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Properties;
import org.jboss.common.beans.property.BeanUtils;
import org.wildfly.extension.undertow.UndertowMessages;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ConfiguredHandlerWrapper
implements HandlerWrapper {
    private final Class<?> handlerClass;
    private final Map<String, String> properties;

    public ConfiguredHandlerWrapper(Class<?> handlerClass, Map<String, String> properties) {
        this.handlerClass = handlerClass;
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpHandler wrap(HttpHandler handler) {
        try {
            Object instance;
            if (HttpHandler.class.isAssignableFrom(this.handlerClass)) {
                Constructor<?> ctor = this.handlerClass.getConstructor(HttpHandler.class);
                instance = ctor.newInstance(handler);
            } else if (HandlerWrapper.class.isAssignableFrom(this.handlerClass)) {
                instance = this.handlerClass.newInstance();
            } else {
                throw UndertowMessages.MESSAGES.handlerWasNotAHandlerOrWrapper(this.handlerClass);
            }
            Properties p = new Properties();
            p.putAll(this.properties);
            ClassLoader oldCl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
            try {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(BeanUtils.class);
                BeanUtils.mapJavaBeanProperties(instance, (Properties)p);
            }
            finally {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldCl);
            }
            if (HttpHandler.class.isAssignableFrom(this.handlerClass)) {
                return (HttpHandler)instance;
            }
            return ((HandlerWrapper)instance).wrap(handler);
        }
        catch (Exception e) {
            throw UndertowMessages.MESSAGES.failedToConfigureHandler(this.handlerClass, e);
        }
    }
}

