/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import org.jacorb.config.Configuration;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.MessageReceptor;
import org.jacorb.util.threadpool.Consumer;
import org.jacorb.util.threadpool.ConsumerFactory;
import org.jacorb.util.threadpool.ThreadPool;
import org.slf4j.Logger;

public class MessageReceptorPool {
    private static final int MAX_DEFAULT = 1000;
    private static final int MAX_IDLE_DEFAULT = 5;
    private final ThreadPool pool;

    public MessageReceptorPool(String config, String threadNamePrefix, Configuration myConfiguration) {
        if (!"server".equals(config) && !"client".equals(config)) {
            throw new IllegalArgumentException("must be client or server");
        }
        final Configuration configuration = myConfiguration;
        int maxConnectionThreads = configuration.getAttributeAsInteger("jacorb.connection." + config + ".max_receptor_threads", 1000);
        int maxIdleThreads = configuration.getAttributeAsInteger("jacorb.connection." + config + ".max_idle_receptor_threads", 5);
        Logger logger = configuration.getLogger("jacorb.orb.giop");
        if (logger.isDebugEnabled()) {
            logger.debug("Maximum connection threads: " + maxConnectionThreads);
            logger.debug("Maximum idle threads: " + maxIdleThreads);
        }
        this.pool = new ThreadPool(configuration, threadNamePrefix, new ConsumerFactory(){

            public Consumer create() {
                return new MessageReceptor(configuration);
            }
        }, maxConnectionThreads, maxIdleThreads);
    }

    public void connectionCreated(GIOPConnection conn) {
        this.pool.putJob(conn);
    }

    public void shutdown() {
        this.pool.shutdown();
    }
}

