/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.IOException;
import org.jacorb.orb.ORB;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ReplyOutputStream;
import org.jacorb.orb.giop.RequestListener;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_POLICY;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.slf4j.Logger;

public class NoBiDirClientRequestListener
implements RequestListener {
    private final Logger logger;
    private final ORB orb;

    public NoBiDirClientRequestListener(ORB orb, Logger logger) {
        this.orb = orb;
        this.logger = logger;
    }

    public void requestReceived(byte[] request, GIOPConnection connection) {
        this.logger.warn("Received a request on a non-bidir connection");
        connection.incPendingMessages();
        this.replyException(request, connection);
    }

    public void locateRequestReceived(byte[] request, GIOPConnection connection) {
        this.logger.warn("Received a locate request on a non-bidir connection");
        connection.incPendingMessages();
        this.replyException(request, connection);
    }

    public void cancelRequestReceived(byte[] request, GIOPConnection connection) {
        this.logger.warn("Received a cancel request on a non-bidir connection");
        connection.incPendingMessages();
        this.replyException(request, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replyException(byte[] request, GIOPConnection connection) {
        int giop_minor = Messages.getGIOPMinor(request);
        ReplyOutputStream out = new ReplyOutputStream(this.orb, Messages.getRequestId(request), ReplyStatusType_1_2.SYSTEM_EXCEPTION, giop_minor, false, this.logger);
        try {
            SystemExceptionHelper.write(out, new INV_POLICY(0, CompletionStatus.COMPLETED_NO));
            connection.sendReply(out);
        }
        catch (IOException e) {
            this.logger.error("unexpected exception during replyException", (Throwable)e);
        }
        finally {
            out.close();
        }
    }
}

