/*
 * Decompiled with CFR 0.152.
 */
package junitparams.internal.parameters;

import java.util.Arrays;
import java.util.List;
import junitparams.FileParameters;
import junitparams.Parameters;
import junitparams.internal.parameters.ParametersFromCustomProvider;
import junitparams.internal.parameters.ParametersFromExternalClassMethod;
import junitparams.internal.parameters.ParametersFromExternalClassProvideMethod;
import junitparams.internal.parameters.ParametersFromTestClassMethod;
import junitparams.internal.parameters.ParametersFromValue;
import junitparams.internal.parameters.ParametrizationStrategy;
import org.junit.runners.model.FrameworkMethod;

public class ParametersReader {
    public static final String ILLEGAL_STATE_EXCEPTION_MESSAGE = String.format("Illegal usage of JUnitParams in method %s. Check that you have only used one supported parameters evaluation strategy. Common case is to use both %s and %s annotations.", "%s", Parameters.class, FileParameters.class);
    private final FrameworkMethod frameworkMethod;
    private final List<ParametrizationStrategy> strategies;

    public ParametersReader(Class<?> testClass, FrameworkMethod frameworkMethod) {
        this.frameworkMethod = frameworkMethod;
        this.strategies = Arrays.asList(new ParametersFromCustomProvider(frameworkMethod), new ParametersFromValue(frameworkMethod), new ParametersFromExternalClassProvideMethod(frameworkMethod), new ParametersFromExternalClassMethod(frameworkMethod), new ParametersFromTestClassMethod(frameworkMethod, testClass));
    }

    public Object[] read() {
        boolean strategyAlreadyFound = false;
        Object[] parameters = new Object[]{};
        for (ParametrizationStrategy strategy : this.strategies) {
            if (!strategy.isApplicable()) continue;
            if (strategyAlreadyFound) {
                this.illegalState();
            }
            parameters = strategy.getParameters();
            strategyAlreadyFound = true;
        }
        if (!strategyAlreadyFound) {
            this.noStrategyFound();
        }
        return parameters;
    }

    private void noStrategyFound() {
        throw new IllegalStateException(String.format("Method %s#%s is annotated with @Parameters but there were no parameters provided.", this.frameworkMethod.getDeclaringClass().getName(), this.frameworkMethod.getName()));
    }

    private void illegalState() {
        throw new IllegalStateException(String.format(ILLEGAL_STATE_EXCEPTION_MESSAGE, this.frameworkMethod.getName()));
    }
}

