/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.hp24.api;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class RelatedVideo
implements Serializable {
    private static final long serialVersionUID = -8723438563601772343L;
    private final String randName;
    private final String userName;
    private final String title;
    private final String urlInterface;
    private final float score;

    public RelatedVideo(String randName, String userName, String title, float score) {
        this.randName = randName;
        this.userName = userName;
        this.title = title;
        this.score = score;
        this.urlInterface = "http://rd3.videos.sapo.pt";
    }

    public RelatedVideo(String randName, String userName, String title, float score, ArrayList<String> interfacs) {
        this.randName = randName;
        this.userName = userName;
        this.title = title;
        this.score = score;
        String interF = "http://rd3.videos.sapo.pt";
        for (String intf : interfacs) {
            if (!StringUtils.isNotEmpty((CharSequence)intf) || !intf.equals("pro.videos.sapo.pt")) continue;
            interF = "http://pro.videos.sapo.pt";
            break;
        }
        this.urlInterface = interF;
    }

    public String getRandName() {
        return this.randName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getTitle() {
        return this.title;
    }

    public float getScore() {
        return this.score;
    }

    public String getUrlInterface() {
        return this.urlInterface;
    }

    public String getVideoUrl() {
        return String.format("%s/%s/mov/1", this.urlInterface, this.randName);
    }

    public String getVideoPic() {
        return String.format("%s/%s/pic/1280x960", this.urlInterface, this.randName);
    }

    public String getVideoPic(String dim) {
        return String.format("%s/%s/pic/%s", this.urlInterface, this.randName, dim);
    }

    public String toString() {
        return String.format("RelatedVideo [randName=%s, userName=%s, title=%s, urlInterface=%s, score=%s, getUrlInterface()=%s, getVideoUrl()=%s, getVideoPic()=%s]", this.randName, this.userName, this.title, this.urlInterface, Float.valueOf(this.score), this.getUrlInterface(), this.getVideoUrl(), this.getVideoPic());
    }
}

