/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.hp24.tools;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import pt.sapo.hp24.tools.Thumbs;
import pt.sapo.hp24.tools.Url;

public class Host {
    private static final String error_pic = Url.enc("http://assets.web.sapo.io/sapologos/touchicon/generic/touch-icon-128.png");
    private static final Map<String, String> host2section;
    private static final Map<String, String> icon;
    private static final Map<String, String> defaultImage;
    private static final Map<String, String> host2source;
    private static final Map<String, String> host2cpid;
    private static final Map<String, Integer> headlineOrder;
    private static final Set<String> full_content;
    private static final Set<String> excludeUrls;

    static {
        excludeUrls = new HashSet<String>();
        full_content = new HashSet<String>();
        full_content.add("www.sapo.pt");
        full_content.add("rr.sapo.pt");
        full_content.add("vmais.rr.sapo.pt");
        full_content.add("tek.sapo.pt");
        full_content.add("mag.sapo.pt");
        full_content.add("lusa.sapo.pt");
        full_content.add("musica.sapo.pt");
        full_content.add("desporto.sapo.pt");
        full_content.add("cinema.sapo.pt");
        full_content.add("sapo24.blogs.sapo.pt");
        full_content.add("comboios150.blogs.sapo.pt");
        host2section = new HashMap<String, String>();
        host2section.put("tek.sapo.pt", "ciencia-tecnologia");
        host2section.put("exameinformatica.sapo.pt", "ciencia-tecnologia");
        host2section.put("pplware.sapo.pt", "ciencia-tecnologia");
        host2section.put("gameover.sapo.pt", "ciencia-tecnologia");
        host2section.put("economico.sapo.pt", "economia");
        host2section.put("musica.sapo.pt", "lifestyle");
        host2section.put("mag.sapo.pt", "lifestyle");
        host2section.put("cinema.sapo.pt", "lifestyle");
        host2section.put("fugas.publico.pt", "lifestyle");
        host2section.put("blitz.sapo.pt", "lifestyle");
        host2section.put("desporto.sapo.pt", "desporto");
        host2section.put("www.record.xl.pt", "desporto");
        host2section.put("www.marca.com", "desporto");
        icon = new HashMap<String, String>();
        icon.put("musica.sapo.pt", "http://assets.web.sapo.io/sapologos/touchicon/generic/touch-icon-128.png");
        icon.put("sapo24.blogs.sapo.pt", "http://assets.web.sapo.io/sapologos/touchicon/generic/touch-icon-128.png");
        icon.put("mag.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/sapocinema_128.png");
        icon.put("cinema.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/sapocinema_128.png");
        icon.put("tek.sapo.pt", "http://imgs.sapo.pt/sapologos/touchicon/tek.sapo.pt/touch-icon-60.png");
        icon.put("greensavers.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/greensavers_128.png");
        icon.put("www.theguardian.com", "http://24.sapo.pt/assets/_logos prontos/guardian_128.png");
        icon.put("www.sol.pt", "http://24.sapo.pt/assets/_logos prontos/sol_128.png");
        icon.put("sicnoticias.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/sicnoticias_128.png");
        icon.put("desporto.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/sapodesporto_128.png");
        icon.put("portocanal.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/portocanal_128.png");
        icon.put("edition.cnn.com", "http://24.sapo.pt/assets/_logos prontos/cnn_128.png");
        icon.put("www.cnn.com", "http://24.sapo.pt/assets/_logos prontos/cnn_128.png");
        icon.put("blitz.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/blitz_128.png");
        icon.put("caras.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/caras_128.png");
        icon.put("activa.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/activa_128.png");
        icon.put("elpais.com", "http://24.sapo.pt/assets/_logos prontos/elpais_128.png");
        icon.put("abola.pt", "http://24.sapo.pt/assets/_logos prontos/abola_128.png");
        icon.put("www.bbc.com", "http://24.sapo.pt/assets/_logos prontos/bbcnews_128.png");
        icon.put("cmtv.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/cmtv_128.png");
        icon.put("diariodigital.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/diariodigital_128.png");
        icon.put("www.dn.pt", "http://24.sapo.pt/assets/_logos prontos/dn_128.png");
        icon.put("economico.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/economico_128.png");
        icon.put("exameinformatica.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/exameinformatica_128.png");
        icon.put("www.ft.com", "http://24.sapo.pt/assets/_logos prontos/ft_128.png");
        icon.put("www.huffingtonpost.com", "http://24.sapo.pt/assets/_logos prontos/ huffingtonpost_128.png");
        icon.put("www.ionline.pt", "http://24.sapo.pt/assets/_logos prontos/ionline_128.png");
        icon.put("expresso.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/expresso_128.png");
        icon.put("www.jn.pt", "http://24.sapo.pt/assets/_logos prontos/jn_128.png");
        icon.put("www.jornaldenegocios.pt", "http://24.sapo.pt/assets/_logos prontos/jornaldenegocios_128.png");
        icon.put("www.marca.com", "http://24.sapo.pt/assets/_logos prontos/marca_128.png");
        icon.put("observador.pt", "http://24.sapo.pt/assets/_logos prontos/observador_128.png");
        icon.put("www.ojogo.pt", "http://24.sapo.pt/assets/_logos prontos/ojogo_128.png");
        icon.put("pplware.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/pplware_128.png");
        icon.put("publico.pt", "http://24.sapo.pt/assets/_logos prontos/publico_128.png");
        icon.put("fugas.publico.pt", "http://24.sapo.pt/assets/_logos prontos/publico_128.png");
        icon.put("www.publico.pt", "http://24.sapo.pt/assets/_logos prontos/publico_128.png");
        icon.put("www.record.xl.pt", "http://24.sapo.pt/assets/_logos prontos/record_128.png");
        icon.put("rr.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/rr_128.png");
        icon.put("www.rtp.pt", "http://24.sapo.pt/assets/_logos prontos/rtp_128.png");
        icon.put("www.tsf.pt", "http://24.sapo.pt/assets/_logos prontos/tsf_128.png");
        icon.put("turbo.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/turbo_128.png");
        icon.put("visao.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/visao_128.png");
        icon.put("vmais.rr.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/vmais_128.png");
        icon.put("www.cmjornal.xl.pt", "http://24.sapo.pt/assets/_logos prontos/cm_128.png");
        icon.put("www.tvi24.iol.pt", "http://24.sapo.pt/assets/_logos prontos/tvi24_128.png");
        icon.put("lusa.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/lusa_128.png");
        icon.put("tek.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/sapotek_128.png");
        icon.put("sapo.pt", "http://www.sapo.pt/favicon.ico");
        defaultImage = new HashMap<String, String>();
        defaultImage.put("economico.sapo.pt", "http://economico.sapo.pt/assets/frontend/img/de-og.jpg");
        defaultImage.put("rr.sapo.pt", "http://mediaserver2.rr.pt/NEWRR/default_664x3731238b845.jpg");
        defaultImage.put("www.fn.pt", "http://cdn.controlinveste.pt/jn/common/images/JN_DEFAULT_IMG.jpg");
        defaultImage.put("www.dn.pt", "http://www.dn.pt/common/images/DN_DEFAULT_IMG.jpg");
        defaultImage.put("sol.pt", "http://sol.pt/fotos/JornalSOL.jpg");
        defaultImage.put("www.sol.pt", "http://sol.pt/fotos/JornalSOL.jpg");
        defaultImage.put("www.cmjornal.xl.pt", "http://24.sapo.pt/assets/_logos prontos/cm_placeholder_16x9.png");
        defaultImage.put("elpais.com", "http://24.sapo.pt/assets/_logos prontos/elpais_logo.jpg");
        defaultImage.put("expresso.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/expresso_default.png");
        defaultImage.put("observador.pt", "http://24.sapo.pt/assets/_logos prontos/observador_default.png");
        defaultImage.put("www.tvi24.iol.pt", "http://24.sapo.pt/assets/_logos prontos/tvi24_default.png");
        defaultImage.put("portocanal.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/portocanal_default.png");
        defaultImage.put("www.publico.pt", "http://24.sapo.pt/assets/_logos prontos/publico_default.png");
        defaultImage.put("www.ojogo.pt", "http://24.sapo.pt/assets/_logos prontos/ojogo_default.png");
        defaultImage.put("greensavers.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/greensavers_default.png");
        defaultImage.put("visao.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/visao_default.png");
        defaultImage.put("www.jn.pt", "http://24.sapo.pt/assets/_logos prontos/jn_default.png");
        defaultImage.put("www.marca.com", "http://24.sapo.pt/assets/_logos prontos/marca_default.png");
        defaultImage.put("lusa.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/lusa_default.png");
        defaultImage.put("www.theguardian.com", "http://24.sapo.pt/assets/_logos prontos/guardian_default.png");
        defaultImage.put("pplware.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/pplware_default.png");
        defaultImage.put("rr.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/rr_default.png");
        defaultImage.put("vmais.rr.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/rr_default.png");
        defaultImage.put("sicnoticias.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/sicnoticias_default.png");
        defaultImage.put("edition.cnn.com", "http://24.sapo.pt/assets/_logos prontos/cnn_default.png");
        defaultImage.put("www.cnn.com", "http://24.sapo.pt/assets/_logos prontos/cnn_default.png");
        defaultImage.put("www.bbc.com", "http://24.sapo.pt/assets/_logos prontos/bbcnews_default.png");
        defaultImage.put("www.tsf.pt", "http://24.sapo.pt/assets/_logos prontos/tsf_default.png");
        defaultImage.put("tek.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/sapotek_default.png");
        defaultImage.put("abola.pt", "http://24.sapo.pt/assets/_logos prontos/abola_placeholder_16x9.png");
        defaultImage.put("activa.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/activa_placeholder_16x9.png");
        defaultImage.put("blitz.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/blitz_placeholder_16x9.png");
        defaultImage.put("caras.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/caras_placeholder_16x9.png");
        defaultImage.put("cmtv.sapo.pt", "http://24.sapo.pt/assets/_logos prontos/cmtv_placeholder_16x9.png");
        defaultImage.put("www.huffingtonpost.com", "http://s.huffpost.com/images/v/logos/v4/homepage.gif");
        defaultImage.put("diariodigital.sapo.pt", "http://i.imgur.com/PaLYzYR.png");
        defaultImage.put("www.jornaldenegocios.pt", "http://i.imgur.com/YUgsPq3.png");
        defaultImage.put("www.ioline.pt", "http://i.imgur.com/UhCcO8A.jpg");
        defaultImage.put("www.rtp.pt", "http://i.imgur.com/k3CAnpP.png");
        defaultImage.put("www.record.xl.pt", "http://www.record.xl.pt/comunidade/common/images/logo_record.jpg");
        defaultImage.put("desporto.sapo.pt", "http://imgs.sapo.pt/marcasapo/imgs/icon-desporto.jpg");
        headlineOrder = new HashMap<String, Integer>();
        headlineOrder.put("publico.pt", 1);
        headlineOrder.put("www.publico.pt", 1);
        headlineOrder.put("rr.sapo.pt", 2);
        headlineOrder.put("sicnoticias.sapo.pt", 3);
        headlineOrder.put("visao.sapo.pt", 4);
        headlineOrder.put("www.tsf.pt", 5);
        headlineOrder.put("expresso.sapo.pt", 6);
        headlineOrder.put("www.rtp.pt", 7);
        headlineOrder.put("economico.sapo.pt", 8);
        headlineOrder.put("www.sol.pt", 8);
        headlineOrder.put("www.ionline.pt", 9);
        headlineOrder.put("www.jn.pt", 10);
        headlineOrder.put("www.dn.pt", 11);
        headlineOrder.put("www.cmjornal.xl.pt", 12);
        headlineOrder.put("www.bbc.com", 13);
        headlineOrder.put("www.cnn.com", 14);
        headlineOrder.put("edition.cnn.com", 15);
        headlineOrder.put("www.ft.com", 16);
        headlineOrder.put("www.theguardian.com", 17);
        headlineOrder.put("elpais.com", 18);
        headlineOrder.put("mag.sapo.pt", 19);
        headlineOrder.put("portocanal.sapo.pt", 20);
        headlineOrder.put("www.jornaldenegocios.pt", 21);
        headlineOrder.put("www.abola.pt", 22);
        headlineOrder.put("desporto.sapo.pt", 23);
        headlineOrder.put("www.record.xl.pt", 24);
        headlineOrder.put("www.marca.com", 25);
        headlineOrder.put("lusa.sapo.pt", 26);
        headlineOrder.put("tek.sapo.pt", 27);
        headlineOrder.put("sapo24.blogs.sapo.pt", 27);
        host2source = new HashMap<String, String>();
        host2source.put("www.washingtonpost.com", "Washington Post");
        host2source.put("lusa.sapo.pt", "Lusa");
        host2source.put("sicnoticias.sapo.pt", "SIC");
        host2source.put("www.abola.pt", "A Bola");
        host2source.put("www.record.xl.pt", "Record");
        host2source.put("observador.pt", "Observador");
        host2source.put("www.jornaldenegocios.pt", "Neg\u00f3cios");
        host2source.put("www.ojogo.pt", "O Jogo");
        host2source.put("www.rtp.pt", "RTP");
        host2source.put("www.publico.pt", "P\u00fablico");
        host2source.put("fugas.publico.pt", "P\u00fablico");
        host2source.put("www.tvi24.iol.pt", "TVI24");
        host2source.put("expresso.sapo.pt", "Expresso");
        host2source.put("economico.sapo.pt", "Economico");
        host2source.put("rr.sapo.pt", "Renascen\u00e7a");
        host2source.put("portocanal.sapo.pt", "Porto Canal");
        host2source.put("desporto.sapo.pt", "SAPO Desporto");
        host2source.put("www.cmjornal.xl.pt", "CM");
        host2source.put("www.dn.pt", "DN");
        host2source.put("diariodigital.sapo.pt", "DD");
        host2source.put("www.tsf.pt", "TSF");
        host2source.put("www.ionline.pt", "iOnline");
        host2source.put("visao.sapo.pt", "Vis\u00e3o");
        host2source.put("www.jn.pt", "JN");
        host2source.put("caras.sapo.pt", "Caras");
        host2source.put("www.sol.pt", "SOL");
        host2source.put("greensavers.sapo.pt", "Greensavers");
        host2source.put("blitz.sapo.pt", "Blitz");
        host2source.put("turbo.sapo.pt", "Turbo");
        host2source.put("tek.sapo.pt", "TeK");
        host2source.put("www.sabado.pt", "S\u00e1bado");
        host2source.put("exameinformatica.sapo.pt", "Exame Inform\u00e1tica");
        host2source.put("activa.sapo.pt", "Activa");
        host2source.put("mag.sapo.pt", "Mag");
        host2source.put("palcoprincipal.sapo.pt", "Palco Principal");
        host2source.put("gameover.sapo.pt", "Gameover");
        host2source.put("musica.sapo.pt", "SAPO M\u00fasica");
        host2source.put("videos.sapo.pt", "SAPO V\u00eddeos");
        host2source.put("querosaber.sapo.pt", "Quero Saber");
        host2source.put("relvado.sapo.pt", "Relvado");
        host2source.put("sabores.sapo.pt", "SAPO Sabores");
        host2cpid = new HashMap<String, String>();
        host2cpid.put("abola.pt", "abola");
        host2cpid.put("activa.sapo.pt", "activa");
        host2cpid.put("blitz.sapo.pt", "blitz");
        host2cpid.put("caras.sapo.pt", "caras");
        host2cpid.put("cmjornal.xl.pt", "cm");
        host2cpid.put("cmtv.sapo.pt", "cmtv");
        host2cpid.put("desporto.sapo.pt", "sapodesporto_24");
        host2cpid.put("diariodigital.sapo.pt", "dd");
        host2cpid.put("dn.pt", "dn");
        host2cpid.put("economico.sapo.pt", "economico");
        host2cpid.put("exameinformatica.sapo.pt", "exameinformatica");
        host2cpid.put("expresso.sapo.pt", "expresso");
        host2cpid.put("gameover.sapo.pt", "gamebasics");
        host2cpid.put("greensavers.sapo.pt", "greensavers");
        host2cpid.put("ionline.pt", "ionline");
        host2cpid.put("jn.pt", "jn");
        host2cpid.put("jornaldenegocios.pt", "negocios");
        host2cpid.put("lusa.fotos.sapo.pt", "lusa");
        host2cpid.put("naturlink.sapo.pt", "naturlinksapo");
        host2cpid.put("observador.pt", "observador");
        host2cpid.put("ojogo.pt", "ojogo");
        host2cpid.put("palcoprincipal.sapo.pt", "palco_principal");
        host2cpid.put("portocanal.sapo.pt", "portocanalonline");
        host2cpid.put("pplware.sapo.pt", "pplware");
        host2cpid.put("publico.pt", "publico");
        host2cpid.put("www.publico.pt", "publico");
        host2cpid.put("fugas.publico.pt", "publico");
        host2cpid.put("record.xl.pt", "record");
        host2cpid.put("relvado.sapo.pt", "relvado");
        host2cpid.put("rr.sapo.pt", "rr");
        host2cpid.put("rtp.pt", "rtp_2014");
        host2cpid.put("sabado.pt", "sabado");
        host2cpid.put("sicnoticias.sapo.pt", "sicnoticias");
        host2cpid.put("sol.sapo.pt", "sol");
        host2cpid.put("tek.sapo.pt", "teksapo");
        host2cpid.put("timeout.sapo.pt", "timeout");
        host2cpid.put("tsf.pt", "tsf");
        host2cpid.put("turbo.sapo.pt", "tvturbo");
        host2cpid.put("tv.sapo.pt", "sapotv_2014");
        host2cpid.put("tvi24.iol.pt", "tvi24");
        host2cpid.put("visao.sapo.pt", "revistavisao");
    }

    public String toString() {
        return "Host []";
    }

    public static Set<String> getFullContent() {
        return full_content;
    }

    public static String icon(String host) {
        return Host.icon(host, 16, 16);
    }

    public static String icon(String host, int w, int h) {
        String url_ico = icon.containsKey(host) ? icon.get(host) : String.format("http://%s/favicon.ico", host);
        StringBuilder thumb = new StringBuilder();
        thumb.append("http://thumbs.web.sapo.io/?pic=");
        thumb.append(Url.enc(url_ico));
        thumb.append("&W=");
        thumb.append(w);
        thumb.append("&H=");
        thumb.append(h);
        thumb.append("&hash=");
        thumb.append(Thumbs.hash(url_ico));
        thumb.append("&errorpic=");
        thumb.append(error_pic);
        thumb.append("&png=1");
        return thumb.toString();
    }

    public static final String category(String host) {
        return host2section.get(host);
    }

    public static final boolean isFullContentAllowed(String host) {
        return full_content.contains(host);
    }

    public static final String defaultImage(String host) {
        return defaultImage.get(host);
    }

    public static final int getHeadlineOrder(String host) {
        if (!headlineOrder.containsKey(host)) {
            return Integer.MAX_VALUE;
        }
        return headlineOrder.get(host);
    }

    public static final String getSourceName(String host) {
        return host2source.get(host);
    }

    public static final String getCpId(String host) {
        if (StringUtils.isNotBlank((CharSequence)host) && StringUtils.isNotBlank((CharSequence)host2cpid.get(host))) {
            return host2cpid.get(host);
        }
        return host;
    }

    public static Set<String> getExcludeurls() {
        return excludeUrls;
    }
}

