/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.codec.protobuf;

import com.google.protobuf.Message;
import java.io.InputStream;
import java.io.OutputStream;
import org.caudexorigo.io.UnsynchronizedByteArrayInputStream;
import org.caudexorigo.io.UnsynchronizedByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.codec.Codec;
import protobuf.codec.json.JsonCodec;
import pt.com.broker.codec.protobuf.PBMessage;
import pt.com.broker.codec.protobuf.ProtoBufBindingSerializer;
import pt.com.broker.types.BindingSerializer;
import pt.com.broker.types.NetMessage;
import pt.com.broker.types.NetProtocolType;

public class JsonCodecForProtoBuf
implements BindingSerializer {
    private static final Logger log = LoggerFactory.getLogger(JsonCodecForProtoBuf.class);
    private static final ProtoBufBindingSerializer protobuf_serializer = new ProtoBufBindingSerializer();
    private static final Codec codec = new JsonCodec();

    public NetMessage unmarshal(InputStream in) {
        try {
            PBMessage.Atom atom = (PBMessage.Atom)codec.toMessage(PBMessage.Atom.class, in);
            return protobuf_serializer.constructMessage(atom);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public NetMessage unmarshal(byte[] packet) {
        try {
            PBMessage.Atom atom = (PBMessage.Atom)codec.toMessage(PBMessage.Atom.class, (InputStream)new UnsynchronizedByteArrayInputStream(packet));
            return protobuf_serializer.constructMessage(atom);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public byte[] marshal(NetMessage message) {
        try {
            PBMessage.Atom atom = protobuf_serializer.buildAtom(message);
            UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream();
            codec.fromMessage((Message)atom, (OutputStream)out);
            return out.toByteArray();
        }
        catch (Throwable t) {
            log.error(t.getMessage(), t);
            return null;
        }
    }

    public void marshal(NetMessage message, OutputStream out) {
        try {
            PBMessage.Atom atom = protobuf_serializer.buildAtom(message);
            codec.fromMessage((Message)atom, out);
        }
        catch (Throwable t) {
            log.error(t.getMessage(), t);
        }
    }

    public NetProtocolType getProtocolType() {
        return NetProtocolType.JSON;
    }
}

