/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.codec.xml;

import java.io.InputStream;
import java.io.OutputStream;
import org.caudexorigo.io.UnsynchronizedByteArrayInputStream;
import org.caudexorigo.io.UnsynchronizedByteArrayOutputStream;
import pt.com.broker.codec.xml.Builder;
import pt.com.broker.codec.xml.SoapSerializer;
import pt.com.broker.codec.xml.soap.SoapEnvelope;
import pt.com.broker.types.BindingSerializer;
import pt.com.broker.types.NetMessage;
import pt.com.broker.types.NetProtocolType;
import pt.com.broker.types.stats.EncodingStats;

public class SoapBindingSerializer
implements BindingSerializer {
    public byte[] marshal(NetMessage message) {
        SoapEnvelope soap = Builder.netMessageToSoap(message);
        UnsynchronizedByteArrayOutputStream holder = new UnsynchronizedByteArrayOutputStream();
        SoapSerializer.ToXml(soap, (OutputStream)holder);
        byte[] data = holder.toByteArray();
        EncodingStats.newSoapEncodedMessage();
        return data;
    }

    public void marshal(NetMessage message, OutputStream out) {
        SoapEnvelope soap = Builder.netMessageToSoap(message);
        SoapSerializer.ToXml(soap, out);
        EncodingStats.newSoapEncodedMessage();
    }

    public NetMessage unmarshal(byte[] packet) {
        UnsynchronizedByteArrayInputStream bin = new UnsynchronizedByteArrayInputStream(packet);
        SoapEnvelope msg = SoapSerializer.FromXml((InputStream)bin);
        NetMessage message = Builder.soapToNetMessage(msg);
        EncodingStats.newSoapDecodedMessage();
        return message;
    }

    public NetMessage unmarshal(InputStream in) {
        SoapEnvelope msg = SoapSerializer.FromXml(in);
        NetMessage message = Builder.soapToNetMessage(msg);
        EncodingStats.newSoapDecodedMessage();
        return message;
    }

    public NetProtocolType getProtocolType() {
        return NetProtocolType.SOAP;
    }
}

