/*
 * Decompiled with CFR 0.152.
 */
package pt.com.gcs.conf;

import java.io.File;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.caudexorigo.Shutdown;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import pt.com.broker.auth.ProviderInfo;
import pt.com.gcs.conf.GcsInfo;
import pt.com.gcs.conf.SchemaValidator;
import pt.com.gcs.conf.XsdValidationResult;
import pt.com.gcs.conf.global.BrokerSecurityPolicy;
import pt.com.gcs.net.Peer;

public class GlobalConfig {
    private static final Logger log = LoggerFactory.getLogger(GlobalConfig.class);
    private final List<Peer> peerList = new ArrayList<Peer>();
    private final Set<InetSocketAddress> peerSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final GlobalConfig instance = new GlobalConfig();
    private static final long DEFAULT_REDELIVERY_INTERVAL = 120000L;
    private AtomicLong last_modified = new AtomicLong(0L);
    private BrokerSecurityPolicy secPolicy;
    private Map<String, ProviderInfo> credentialValidatiorProviders = new TreeMap<String, ProviderInfo>();
    private int msgMaxSize;
    private int maxQueues;
    private long maxStoreTime;
    private long queueMaxStaleAge;
    private long queueRedeliveryInterval;
    private int maxDistinctSubscriptions;
    private boolean preferLocalConsumers = true;
    private boolean supportVirtualQueues = true;
    private Map<String, Long> queuePrefixConfig = new HashMap<String, Long>();

    private GlobalConfig() {
        try {
            String configFile = GcsInfo.getGlobalConfigFilePath();
            String globalConfigPath = null;
            File xmlFile = null;
            StreamSource schemaLocation = new StreamSource(GlobalConfig.class.getResourceAsStream("/pt/com/gcs/etc/global_config.xsd"));
            URL globalConfigUrl = this.getClass().getClassLoader().getResource(configFile);
            if (globalConfigUrl != null) {
                xmlFile = new File(globalConfigUrl.toURI());
                globalConfigPath = globalConfigUrl.toURI().getPath();
            } else {
                xmlFile = new File(configFile);
                globalConfigPath = configFile;
            }
            XsdValidationResult result = SchemaValidator.validate(schemaLocation, xmlFile);
            if (!result.isValid()) {
                log.error("Invalid Global configuration file, aborting startup.");
                log.error(result.getMessage());
                Shutdown.now();
            }
            Document doc = this.parseXmlFile(globalConfigPath, false);
            this.init(doc);
        }
        catch (URISyntaxException e) {
            log.error("Fatal error: {}", (Object)e.getMessage());
            Shutdown.now((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Document doc) {
        this.populateWorldMap(doc);
        this.extractSecurityPolicies(doc);
        this.extractMessageConfiguration(doc);
        Map<String, ProviderInfo> map = this.credentialValidatiorProviders;
        synchronized (map) {
            this.credentialValidatiorProviders.clear();
            this.loadCredentialValidatiorProviders(doc);
        }
    }

    private void extractMessageConfiguration(Document doc) {
        String supportVirtualQueuesStr;
        String[] svqElementInfo;
        String preferLocalConsumersStr;
        String maxSizeStr = this.extractElementInfo(doc, "max-msg-size")[0];
        this.msgMaxSize = Integer.parseInt(maxSizeStr);
        String maxQueueSize = this.extractElementInfo(doc, "max-queues")[0];
        this.maxQueues = Integer.parseInt(maxQueueSize);
        String[] sMaxQueueStaleAgeHolder = this.extractElementInfo(doc, "max-stale-age");
        this.queueMaxStaleAge = sMaxQueueStaleAgeHolder.length > 0 && StringUtils.isNotBlank((CharSequence)sMaxQueueStaleAgeHolder[0]) ? (long)Integer.parseInt(sMaxQueueStaleAgeHolder[0]) : 1296000000L;
        String[] sRedeliveryIntervalolder = this.extractElementInfo(doc, "redelivery-interval");
        this.queueRedeliveryInterval = sRedeliveryIntervalolder.length > 0 && StringUtils.isNotBlank((CharSequence)sRedeliveryIntervalolder[0]) ? (long)Integer.parseInt(sRedeliveryIntervalolder[0]) : 120000L;
        String[] plcElementInfo = this.extractElementInfo(doc, "prefer-local-consumers");
        if (plcElementInfo != null && plcElementInfo.length != 0 && StringUtils.isNotBlank((CharSequence)(preferLocalConsumersStr = plcElementInfo[0]))) {
            this.preferLocalConsumers = preferLocalConsumersStr.toLowerCase().equals("true");
        }
        if ((svqElementInfo = this.extractElementInfo(doc, "support-virtual-queues")) != null && svqElementInfo.length != 0 && StringUtils.isNotBlank((CharSequence)(supportVirtualQueuesStr = svqElementInfo[0]))) {
            this.supportVirtualQueues = supportVirtualQueuesStr.toLowerCase().equals("true");
        }
        String maxDistinctSubscriptionsStr = this.extractElementInfo(doc, "max-distinct-subscriptions")[0];
        this.maxDistinctSubscriptions = Integer.parseInt(maxDistinctSubscriptionsStr);
        String maxStoreTimeStr = this.extractElementInfo(doc, "store-time")[0];
        this.maxStoreTime = Long.parseLong(maxStoreTimeStr);
        this.queuePrefixConfig = this.loadQueuePrefixConfig(doc);
    }

    private Map<String, Long> loadQueuePrefixConfig(Document doc) {
        HashMap<String, Long> queuePrefixConfig = new HashMap<String, Long>();
        NodeList prefixes = doc.getElementsByTagName("prefixes");
        if (prefixes.getLength() > 0) {
            NodeList prefixNodes = ((Element)prefixes.item(0)).getElementsByTagName("prefix");
            for (int i = 0; i < prefixNodes.getLength(); ++i) {
                Element prefixNode = (Element)prefixNodes.item(i);
                String prefixName = prefixNode.getElementsByTagName("name").item(0).getFirstChild().getNodeValue();
                Long prefixStaleAge = Long.valueOf(prefixNode.getElementsByTagName("max-stale-age").item(0).getFirstChild().getNodeValue());
                queuePrefixConfig.put(prefixName, prefixStaleAge);
            }
        }
        return queuePrefixConfig;
    }

    private synchronized void populateWorldMap(Document doc) {
        String selfName = GcsInfo.getAgentName();
        String selfHost = GcsInfo.getAgentHost();
        int selfPort = GcsInfo.getAgentPort();
        int npeers = doc.getElementsByTagName("peer").getLength();
        String[] hosts = this.extractElementInfo(doc, "ip");
        String[] ports = this.extractElementInfo(doc, "port");
        boolean isSelfPeerInWorldMap = false;
        this.peerList.clear();
        this.peerSet.clear();
        for (int i = 0; i < npeers; ++i) {
            String agentName = GcsInfo.constructAgentName(hosts[i], Integer.parseInt(ports[i]));
            if (selfName.equalsIgnoreCase(agentName)) {
                if (!selfHost.equalsIgnoreCase(hosts[i]) || selfPort != Integer.parseInt(ports[i])) continue;
                isSelfPeerInWorldMap = true;
                continue;
            }
            Peer p = new Peer(agentName, hosts[i], Integer.parseInt(ports[i]));
            InetSocketAddress inet = new InetSocketAddress(p.getHost(), p.getPort());
            this.peerList.add(p);
            this.peerSet.add(inet);
        }
        if (!isSelfPeerInWorldMap) {
            System.err.println("This peer it's not in the world map.");
            Shutdown.now();
        }
    }

    private String[] extractElementInfo(Document doc, String tag) {
        NodeList nList = doc.getElementsByTagName(tag);
        if (nList.getLength() > 0) {
            String[] value = new String[nList.getLength()];
            for (int i = 0; i < nList.getLength(); ++i) {
                Element name = (Element)nList.item(i);
                value[i] = name.getTextContent();
            }
            return value;
        }
        return new String[0];
    }

    public static List<Peer> getPeerList() {
        return Collections.unmodifiableList(GlobalConfig.instance.peerList);
    }

    public static boolean contains(InetSocketAddress inet) {
        return GlobalConfig.instance.peerSet.contains(inet);
    }

    public static boolean preferLocalConsumers() {
        return GlobalConfig.instance.preferLocalConsumers;
    }

    public static boolean supportVirtualQueues() {
        return GlobalConfig.instance.supportVirtualQueues;
    }

    private Document parseXmlFile(String filename, boolean validating) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validating);
            File xmlFile = new File(filename);
            this.last_modified.set(xmlFile.lastModified());
            Document doc = factory.newDocumentBuilder().parse(xmlFile);
            return doc;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private void extractSecurityPolicies(Document doc) {
        NodeList secPolicies = doc.getElementsByTagName("security-policies");
        if (secPolicies.getLength() != 0) {
            try {
                BrokerSecurityPolicy brokerSecPolicies;
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{BrokerSecurityPolicy.class});
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                JAXBElement element = unmarshaller.unmarshal(secPolicies.item(0), BrokerSecurityPolicy.class);
                this.secPolicy = brokerSecPolicies = (BrokerSecurityPolicy)element.getValue();
            }
            catch (JAXBException e) {
                log.error("Error parsing Broker security policies", (Throwable)e);
                this.secPolicy = null;
            }
        } else {
            this.secPolicy = null;
        }
    }

    public static Map<String, ProviderInfo> getCredentialValidatorProviders() {
        return GlobalConfig.instance.credentialValidatiorProviders;
    }

    private void loadCredentialValidatiorProviders(Document doc) {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList nodes = (NodeList)xpath.evaluate("/global-config/credential-validators/credential-validator", doc, XPathConstants.NODESET);
            for (int i = 0; i != nodes.getLength(); ++i) {
                try {
                    if (!(nodes.item(i) instanceof Element)) continue;
                    String provName = null;
                    String provPath = null;
                    Element provParams = null;
                    Element elem = (Element)nodes.item(i);
                    provName = elem.getAttribute("provider-name");
                    provPath = elem.getElementsByTagName("class").item(0).getTextContent();
                    NodeList paramsNodeList = elem.getElementsByTagName("provider-params");
                    if (paramsNodeList.getLength() != 0) {
                        provParams = (Element)paramsNodeList.item(0);
                    }
                    ProviderInfo provInfo = new ProviderInfo(provName, provPath, provParams);
                    this.credentialValidatiorProviders.put(provName, provInfo);
                    continue;
                }
                catch (Exception e) {
                    log.error("Error parsing an credential-validator", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error("Error parsing credential-validators", (Throwable)e);
        }
    }

    private synchronized boolean i_reload() {
        long lmod;
        boolean wasReloaded = false;
        String globalConfigPath = GcsInfo.getGlobalConfigFilePath();
        File xmlFile = new File(globalConfigPath);
        long modified = xmlFile.lastModified();
        if (modified != (lmod = this.last_modified.getAndSet(modified))) {
            log.info("New world map detected");
            Document doc = this.parseXmlFile(globalConfigPath, false);
            this.init(doc);
            wasReloaded = true;
        }
        return wasReloaded;
    }

    public static boolean reload() {
        return instance.i_reload();
    }

    public static BrokerSecurityPolicy getSecurityPolicies() {
        return GlobalConfig.instance.secPolicy;
    }

    public static int getMsgMaxSize() {
        return GlobalConfig.instance.msgMaxSize;
    }

    public static int getMaxQueues() {
        return GlobalConfig.instance.maxQueues;
    }

    public static long getQueueMaxStaleAge() {
        return GlobalConfig.instance.queueMaxStaleAge;
    }

    public static long getRedeliveryInterval() {
        return GlobalConfig.instance.queueRedeliveryInterval;
    }

    public static long getMaxStoreTime() {
        return GlobalConfig.instance.maxStoreTime;
    }

    public static int getMaxDistinctSubscriptions() {
        return GlobalConfig.instance.maxDistinctSubscriptions;
    }

    public static Map<String, Long> getQueuePrefixConfig() {
        return GlobalConfig.instance.queuePrefixConfig;
    }
}

