/*
 * Decompiled with CFR 0.152.
 */
package pt.com.gcs.messaging;

import java.util.Date;
import org.caudexorigo.time.ISO8601;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetBrokerMessage;
import pt.com.broker.types.NetPublish;
import pt.com.gcs.conf.GcsInfo;
import pt.com.gcs.messaging.Gcs;
import pt.com.gcs.stats.ChannelStatistics;
import pt.com.gcs.stats.QueueStatistics;
import pt.com.gcs.stats.Statistics;
import pt.com.gcs.stats.TopicStatistics;

public class GlobalStatisticsPublisher {
    private static Logger log = LoggerFactory.getLogger(GlobalStatisticsPublisher.class);
    private Date currentDate;
    private Date oldDate;
    private Statistics statistics;

    public GlobalStatisticsPublisher(Date oldDate, Date currentDate, Statistics statistics) {
        this.oldDate = oldDate;
        this.currentDate = currentDate;
        this.statistics = statistics;
    }

    public void publishStatistics() {
        long difSeconds = (this.currentDate.getTime() - this.oldDate.getTime()) / 1000L;
        String currentDateStr = ISO8601.format((Date)this.currentDate);
        this.publishQueueInfo(currentDateStr, difSeconds);
        this.publishTopicInfo(currentDateStr, difSeconds);
        this.publishChannelInfo(currentDateStr, difSeconds);
        this.publishMiscInformation(currentDateStr, difSeconds);
    }

    private void publishQueueInfo(String date, long seconds) {
        double dSeconds = seconds;
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("<mqinfo date='%s' agent-name='%s'>", date, GcsInfo.getAgentName()));
        for (QueueStatistics queueStats : this.statistics.getQueueStatistics()) {
            double rate;
            StringBuilder qSb = new StringBuilder();
            int infoCount = 0;
            long value = queueStats.getReceivedMessages();
            if (value != -1L) {
                rate = (double)value / dSeconds;
                qSb.append(String.format("\n\t<item subject=\"queue://%s\" predicate=\"input-rate\" value=\"%s\" />", queueStats.getQueueName(), rate));
                ++infoCount;
            }
            if ((value = queueStats.getDeliveredMessages().longValue()) != -1L) {
                rate = (double)value / dSeconds;
                qSb.append(String.format("\n\t<item subject=\"queue://%s\" predicate=\"output-rate\" value=\"%s\" />", queueStats.getQueueName(), rate));
                ++infoCount;
            }
            if ((value = queueStats.getExpiredMessages().longValue()) != -1L) {
                rate = (double)value / dSeconds;
                qSb.append(String.format("\n\t<item subject=\"queue://%s\" predicate=\"expired-rate\" value=\"%s\" />", queueStats.getQueueName(), rate));
                ++infoCount;
            }
            if ((value = queueStats.getRedeliveredMessages().longValue()) != -1L) {
                rate = (double)value / dSeconds;
                qSb.append(String.format("\n\t<item subject=\"queue://%s\" predicate=\"redelivered-rate\" value=\"%s\" />", queueStats.getQueueName(), rate));
                ++infoCount;
            }
            if (infoCount == 0) continue;
            sb.append(qSb.toString());
        }
        sb.append(String.format("\n\t<item subject=\"queue\" predicate=\"count\" value=\"%s\" />", this.statistics.getQueueStatistics().size()));
        sb.append("\n</mqinfo>");
        String result = sb.toString();
        String sys_topic = String.format("/system/stats/queues/#%s#", GcsInfo.getAgentName());
        NetPublish np = new NetPublish(sys_topic, NetAction.DestinationType.TOPIC, new NetBrokerMessage(result));
        Gcs.publish(np);
    }

    private void publishTopicInfo(String date, long seconds) {
        double dSeconds = seconds;
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("<mqinfo date='%s' agent-name='%s'>", date, GcsInfo.getAgentName()));
        double rate = (double)this.statistics.getSystemStatistics().getReceivedTopicMessages().longValue() / dSeconds;
        sb.append(String.format("\n\t<item subject='topic://.*' predicate='input-rate' value='%s' />", rate));
        for (TopicStatistics topicStats : this.statistics.getTopicStatistics()) {
            StringBuilder tSb = new StringBuilder();
            int infoCount = 0;
            long value = topicStats.getDeliveredMessages();
            if (value != -1L) {
                rate = (double)value / dSeconds;
                tSb.append(String.format("\n\t<item subject=\"topic://%s\" predicate=\"output-rate\" value=\"%s\" />", topicStats.getTopicName(), rate));
                ++infoCount;
            }
            if ((value = topicStats.getDiscardedMessages().longValue()) != -1L) {
                rate = (double)value / dSeconds;
                tSb.append(String.format("\n\t<item subject=\"topic://%s\" predicate=\"discarded-rate\" value=\"%s\" />", topicStats.getTopicName(), rate));
                ++infoCount;
            }
            if ((value = topicStats.getDispatchedToQueueMessages().longValue()) != -1L) {
                rate = (double)value / dSeconds;
                tSb.append(String.format("\n\t<item subject=\"topic://%s\" predicate=\"dispatched-to-queue-rate\" value=\"%s\" />", topicStats.getTopicName(), rate));
                ++infoCount;
            }
            if (infoCount == 0) continue;
            sb.append(tSb.toString());
        }
        sb.append("\n</mqinfo>");
        String result = sb.toString();
        String sys_topic = String.format("/system/stats/topics/#%s#", GcsInfo.getAgentName());
        NetPublish np = new NetPublish(sys_topic, NetAction.DestinationType.TOPIC, new NetBrokerMessage(result));
        Gcs.publish(np);
    }

    private void publishChannelInfo(String date, long seconds) {
        double dSeconds = seconds;
        StringBuilder sb = new StringBuilder();
        for (ChannelStatistics channelStats : this.statistics.getChannelStatistics()) {
            sb.append(String.format("<mqinfo date='%s' agent-name='%s'>", date, GcsInfo.getAgentName()));
            double rate = (double)channelStats.getReceivedMessages().longValue() / dSeconds;
            sb.append(String.format("\n\t<item subject='%s' predicate='input-rate' value='%s' />", channelStats.getChannelName(), rate));
            sb.append("\n</mqinfo>");
        }
        String result = sb.toString();
        String sys_topic = String.format("/system/stats/channels/#%s#", GcsInfo.getAgentName());
        NetPublish np = new NetPublish(sys_topic, NetAction.DestinationType.TOPIC, new NetBrokerMessage(result));
        Gcs.publish(np);
    }

    private void publishMiscInformation(String date, long seconds) {
        double dSeconds = seconds;
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("<mqinfo date='%s' agent-name='%s'>", date, GcsInfo.getAgentName()));
        double rate = (double)this.statistics.getSystemStatistics().getInvalidMessages().longValue() / dSeconds;
        sb.append(String.format("\n\t<item subject='invalid-messages' predicate='input-rate' value='%s' />", rate));
        rate = this.statistics.getSystemStatistics().getAccessDeniedMessages().longValue();
        if (rate > 0.0) {
            sb.append(String.format("\n\t<item subject='access' predicate='denied' value='%s' />", rate));
        }
        sb.append(String.format("\n\t<item subject='tcp' predicate='connections' value='%s' />", this.statistics.getSystemStatistics().getTcpConnections()));
        sb.append(String.format("\n\t<item subject='tcp-legacy' predicate='connections' value='%s' />", this.statistics.getSystemStatistics().getTcpLegacyConnections()));
        sb.append(String.format("\n\t<item subject='ssl' predicate='connections' value='%s' />", this.statistics.getSystemStatistics().getSslConnections()));
        long f_sys_msgs = this.statistics.getSystemStatistics().getFailedMessages();
        sb.append(String.format("\n\t<item subject='system-message' predicate='failed-delivery' value='%s' />", f_sys_msgs));
        rate = (double)this.statistics.getSystemStatistics().getSystemFaults().longValue() / dSeconds;
        sb.append(String.format("\n\t<item subject='faults' predicate='rate' value='%s' />", rate));
        sb.append("\n</mqinfo>");
        String result = sb.toString();
        String sys_topic = String.format("/system/stats/misc/#%s#", GcsInfo.getAgentName());
        NetPublish np = new NetPublish(sys_topic, NetAction.DestinationType.TOPIC, new NetBrokerMessage(result));
        Gcs.publish(np);
        log.info("Failed system messages: '{}'.", (Object)f_sys_msgs);
    }
}

