/*
 * Decompiled with CFR 0.152.
 */
package pt.com.gcs.messaging;

import io.netty.channel.ChannelHandlerContext;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InboundRemoteChannels {
    private static Logger log = LoggerFactory.getLogger(InboundRemoteChannels.class);
    private static ConcurrentHashMap<String, ChannelHandlerContext> remoteChannels = new ConcurrentHashMap();

    public static ChannelHandlerContext add(String agentId, ChannelHandlerContext channel) {
        ChannelHandlerContext previous = remoteChannels.put(agentId, channel);
        log.info("Adding new ChannelHandlerContext to InboundRemoteChannels. Current size: " + remoteChannels.size());
        return previous;
    }

    public static ChannelHandlerContext get(String agentId) {
        return remoteChannels.get(agentId);
    }

    public static boolean remove(ChannelHandlerContext channel) {
        for (Map.Entry<String, ChannelHandlerContext> entry : remoteChannels.entrySet()) {
            if (!entry.getValue().equals(channel)) continue;
            remoteChannels.remove(entry.getKey());
            return true;
        }
        return false;
    }

    public static Map<String, ChannelHandlerContext> getAll() {
        return new HashMap<String, ChannelHandlerContext>(remoteChannels);
    }
}

