/*
 * Decompiled with CFR 0.152.
 */
package pt.com.gcs.messaging;

import java.util.Collection;
import java.util.Date;
import org.caudexorigo.time.ISO8601;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.gcs.conf.GcsInfo;
import pt.com.gcs.messaging.InternalPublisher;
import pt.com.gcs.messaging.QueueProcessor;
import pt.com.gcs.messaging.QueueProcessorList;

class QueueLister
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(QueueLister.class);

    QueueLister() {
    }

    @Override
    public void run() {
        Collection<QueueProcessor> qpl = QueueProcessorList.values();
        log.debug("Number of registered Queues: {}", (Object)qpl.size());
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("<mqinfo date='%s' agent-name='%s'>", ISO8601.format((Date)new Date()), GcsInfo.getAgentName()));
        for (QueueProcessor qp : QueueProcessorList.values()) {
            sb.append(String.format("\n\t<item subject=\"queue://%s\" predicate=\"queue-listing\" value=\"0\" />", qp.getQueueName()));
        }
        sb.append("\n</mqinfo>");
        String result = sb.toString();
        String sys_topic = String.format("/system/stats/queues/#%s#", GcsInfo.getAgentName());
        InternalPublisher.send(sys_topic, result);
    }
}

