/*
 * Decompiled with CFR 0.152.
 */
package pt.com.gcs.messaging;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.caudexorigo.ErrorAnalyser;
import org.caudexorigo.ds.Cache;
import org.caudexorigo.ds.CacheFiller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.types.CriticalErrors;
import pt.com.broker.types.MessageListener;
import pt.com.broker.types.channels.ListenerChannel;
import pt.com.broker.types.channels.ListenerChannelFactory;
import pt.com.gcs.conf.GcsInfo;
import pt.com.gcs.conf.GlobalConfig;
import pt.com.gcs.messaging.Gcs;
import pt.com.gcs.messaging.QueueProcessor;
import pt.com.gcs.messaging.SubscriptionProcessor;
import pt.com.gcs.messaging.SubscriptionProcessorList;

public class QueueProcessorList
implements SubscriptionProcessorList {
    private static final Logger log = LoggerFactory.getLogger(QueueProcessorList.class);
    private static final QueueProcessorList instance = new QueueProcessorList();
    private static final CacheFiller<String, QueueProcessor> qp_cf = new CacheFiller<String, QueueProcessor>(){

        public QueueProcessor populate(String destinationName) {
            try {
                if (GcsInfo.getMaxQueues() != -1 && instance.qpCache.size() > GcsInfo.getMaxQueues()) {
                    throw new MaximumQueuesAllowedReachedException();
                }
                log.info("Populate QueueProcessorList with queue: '{}'", (Object)destinationName);
                QueueProcessor qp = new QueueProcessor(destinationName, GlobalConfig.getQueueMaxStaleAge());
                return qp;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    };
    private Cache<String, QueueProcessor> qpCache = new Cache();

    public static void broadcast(String action, Channel channel) {
        instance.i_broadcast(action, channel);
    }

    public static QueueProcessor get(String destinationName) {
        return instance.i_get(destinationName);
    }

    public static boolean hasQueue(String queueName) {
        try {
            return QueueProcessorList.instance.qpCache.containsKey((Object)queueName);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    protected static void remove(String queueName, boolean safe) {
        instance.i_remove(queueName, safe);
    }

    protected static void remove(String queueName) {
        instance.i_remove(queueName, true);
    }

    public static void removeListener(MessageListener listener) {
        instance.i_removeListener(listener);
    }

    public static void removeSession(ChannelHandlerContext context) {
        instance.i_removeSession(context);
    }

    public static Collection<QueueProcessor> values() {
        return instance.i_values();
    }

    public static Collection<QueueProcessor> findByPattern(String searchPattern) {
        ArrayList<QueueProcessor> matchingQueues = new ArrayList<QueueProcessor>();
        Collection<QueueProcessor> queues = instance.i_values();
        Pattern matchingPattern = Pattern.compile(searchPattern);
        for (QueueProcessor queueProcessor : queues) {
            Matcher match = matchingPattern.matcher(queueProcessor.getQueueName());
            if (!match.matches()) continue;
            matchingQueues.add(queueProcessor);
        }
        return matchingQueues;
    }

    public static SubscriptionProcessorList getInstance() {
        return instance;
    }

    private QueueProcessorList() {
    }

    private void i_broadcast(String action, Channel channel) {
        try {
            for (QueueProcessor qp : this.qpCache.values()) {
                if (qp.localListeners().size() <= 0) continue;
                qp.broadCastQueueInfo(action, channel);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private QueueProcessor i_get(String destinationName) {
        log.debug("Get Queue for: {}", (Object)destinationName);
        try {
            return (QueueProcessor)this.qpCache.get((Object)destinationName, qp_cf);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ie);
        }
        catch (Throwable t) {
            log.error(String.format("Failed to get QueueProcessor for queue '%s'. Message: %s", destinationName, t.getMessage()), t);
            Throwable rootCause = ErrorAnalyser.findRootCause((Throwable)t);
            CriticalErrors.exitIfCritical((Throwable)rootCause);
            if (rootCause.getClass().isAssignableFrom(MaximumQueuesAllowedReachedException.class)) {
                try {
                    this.qpCache.remove((Object)destinationName);
                }
                catch (InterruptedException e) {
                    log.error("Failed to removed queue processor entry that caused  MaximumQueuesAllowedReachedException. Reason: '{}'", (Throwable)e);
                }
                Gcs.broadcastMaxQueueSizeReached();
            }
            log.error(String.format("Failed to get TopicProcessor for topic '%s'. Message: %s", destinationName, rootCause.getMessage()), rootCause);
            return null;
        }
    }

    private synchronized void i_remove(String queueName, boolean safe) {
        try {
            QueueProcessor qp;
            if (!this.qpCache.containsKey((Object)queueName)) {
                throw new IllegalArgumentException(String.format("Queue named '%s' doesn't exist.", queueName));
            }
            try {
                qp = QueueProcessorList.get(queueName);
            }
            catch (MaximumQueuesAllowedReachedException e) {
                log.error("Trying to remove an inexistent queue.");
                return;
            }
            if (safe && qp.hasRecipient()) {
                String m = String.format("Queue '%s' has active consumers.", queueName);
                throw new IllegalStateException(m);
            }
            this.qpCache.remove((Object)queueName);
            qp.clearStorage();
            log.info("Destination '{}' was deleted", (Object)queueName);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ie);
        }
    }

    private void i_removeListener(MessageListener listener) {
        try {
            for (QueueProcessor qp : this.qpCache.values()) {
                if (!qp.getQueueName().equals(listener.getsubscriptionKey())) continue;
                qp.remove(listener);
                break;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private void i_removeSession(ChannelHandlerContext context) {
        try {
            ListenerChannel lc = ListenerChannelFactory.getListenerChannel((ChannelHandlerContext)context);
            for (QueueProcessor qp : this.qpCache.values()) {
                ArrayList<MessageListener> toDelete = new ArrayList<MessageListener>();
                for (MessageListener ml : qp.localListeners()) {
                    if (!ml.getChannel().equals((Object)lc)) continue;
                    toDelete.add(ml);
                }
                for (MessageListener ml : qp.remoteListeners()) {
                    if (!ml.getChannel().equals((Object)lc)) continue;
                    toDelete.add(ml);
                }
                for (MessageListener dml : toDelete) {
                    qp.remove(dml);
                }
                toDelete.clear();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private Collection<QueueProcessor> i_values() {
        try {
            return this.qpCache.values();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ie);
        }
    }

    @Override
    public SubscriptionProcessor getSubscriptionProcessor(String name) {
        return this.i_get(name);
    }

    @Override
    public Collection<SubscriptionProcessor> getValues() {
        return this.i_values();
    }

    public static class MaximumQueuesAllowedReachedException
    extends RuntimeException {
        private static final long serialVersionUID = 542857696958738718L;

        @Override
        public String getMessage() {
            return "Maximum queues allowed reached";
        }
    }
}

