/*
 * Decompiled with CFR 0.152.
 */
package pt.com.gcs.messaging;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.types.DeliverableMessage;
import pt.com.broker.types.ForwardResult;
import pt.com.broker.types.MessageListener;
import pt.com.broker.types.MessageListenerBase;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetMessage;
import pt.com.broker.types.channels.ListenerChannel;
import pt.com.gcs.conf.GlobalConfig;

public class RemoteListener
extends MessageListenerBase {
    private static final Logger log = LoggerFactory.getLogger(RemoteListener.class);
    private final ListenerChannel lchannel;
    private final String subscriptionKey;
    private final NetAction.DestinationType sourceType;
    private final NetAction.DestinationType targetType;
    private static final ForwardResult failed = new ForwardResult(ForwardResult.Result.FAILED);
    private static final ForwardResult successQueue = new ForwardResult(ForwardResult.Result.SUCCESS, GlobalConfig.getRedeliveryInterval());
    private static final ForwardResult successTopic = new ForwardResult(ForwardResult.Result.SUCCESS);
    private final ForwardResult success;
    private boolean showSuspendedDeliveryMessage;
    private AtomicBoolean isReady = new AtomicBoolean(true);

    public RemoteListener(ListenerChannel lchannel, String subscriptionKey, NetAction.DestinationType sourceType, NetAction.DestinationType targetType) {
        this.lchannel = lchannel;
        this.subscriptionKey = subscriptionKey;
        this.sourceType = sourceType;
        this.targetType = targetType;
        this.showSuspendedDeliveryMessage = true;
        this.success = targetType == NetAction.DestinationType.QUEUE ? successQueue : successTopic;
    }

    public ListenerChannel getChannel() {
        return this.lchannel;
    }

    public String getsubscriptionKey() {
        return this.subscriptionKey;
    }

    public NetAction.DestinationType getSourceDestinationType() {
        return this.sourceType;
    }

    public NetAction.DestinationType getTargetDestinationType() {
        return this.targetType;
    }

    public boolean isAckRequired() {
        return true;
    }

    public boolean isActive() {
        return true;
    }

    public MessageListener.Type getType() {
        return MessageListener.Type.REMOTE;
    }

    public boolean isReady() {
        return this.isReady.get();
    }

    private void setReady(boolean ready) {
        this.isReady.set(ready);
        this.onEventChange(ready ? MessageListener.MessageListenerState.Ready : MessageListener.MessageListenerState.NotReady);
    }

    public ForwardResult onMessage(DeliverableMessage message) {
        if (message == null) {
            return failed;
        }
        NetMessage nmsg = null;
        if (!(message instanceof NetMessage)) {
            log.warn("Don't know how to handle this message type: " + message.getClass().getName());
            return failed;
        }
        nmsg = (NetMessage)message;
        if (this.targetType == NetAction.DestinationType.TOPIC) {
            nmsg.getHeaders().put("TYPE", "COM_TOPIC");
        } else if (this.targetType == NetAction.DestinationType.QUEUE) {
            nmsg.getHeaders().put("TYPE", "COM_QUEUE");
        }
        final ListenerChannel lchannel = this.getChannel();
        try {
            if (lchannel.isWritable()) {
                lchannel.writeAndFlush((Object)nmsg);
                this.setReady(true);
            } else if (this.isReady()) {
                ChannelFuture future = lchannel.writeAndFlush((Object)nmsg);
                this.setReady(false);
                if (this.showSuspendedDeliveryMessage && log.isDebugEnabled()) {
                    log.debug(String.format("Suspending message delivery for %s '%s' to session '%s'.", this.getSourceDestinationType(), this.getsubscriptionKey(), lchannel.getRemoteAddressAsString()));
                }
                future.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            RemoteListener.this.setReady(true);
                        }
                        if (lchannel.isWritable()) {
                            if (log.isDebugEnabled()) {
                                log.debug(String.format("Resume message delivery for %s '%s' to session '%s'.", RemoteListener.this.getSourceDestinationType(), RemoteListener.this.getsubscriptionKey(), lchannel.getRemoteAddressAsString()));
                            }
                            RemoteListener.this.showSuspendedDeliveryMessage = true;
                        } else {
                            RemoteListener.this.showSuspendedDeliveryMessage = false;
                        }
                    }
                });
            } else {
                return failed;
            }
            return this.success;
        }
        catch (Throwable ct) {
            log.error(ct.getMessage(), ct);
            try {
                lchannel.close();
            }
            catch (Throwable ict) {
                log.error(ict.getMessage(), ict);
            }
            return failed;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lchannel == null ? 0 : this.lchannel.hashCode());
        result = 31 * result + (this.sourceType == null ? 0 : this.sourceType.hashCode());
        result = 31 * result + (this.subscriptionKey == null ? 0 : this.subscriptionKey.hashCode());
        result = 31 * result + (this.targetType == null ? 0 : this.targetType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RemoteListener other = (RemoteListener)((Object)obj);
        if (this.lchannel == null ? other.lchannel != null : !this.lchannel.equals((Object)other.lchannel)) {
            return false;
        }
        if (this.sourceType == null ? other.sourceType != null : !this.sourceType.equals((Object)other.sourceType)) {
            return false;
        }
        if (this.subscriptionKey == null ? other.subscriptionKey != null : !this.subscriptionKey.equals(other.subscriptionKey)) {
            return false;
        }
        return !(this.targetType == null ? other.targetType != null : !this.targetType.equals((Object)other.targetType));
    }

    public String toString() {
        return "RemoteListener [type=" + this.getType().toString() + ", lchannel=" + this.lchannel + ", subscriptionKey=" + this.subscriptionKey + "]";
    }
}

