/*
 * Decompiled with CFR 0.152.
 */
package pt.com.gcs.messaging;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicLong;
import org.caudexorigo.ErrorAnalyser;
import org.caudexorigo.ds.Cache;
import org.caudexorigo.ds.CacheFiller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.types.CriticalErrors;
import pt.com.broker.types.MessageListener;
import pt.com.broker.types.NetPublish;
import pt.com.broker.types.channels.ListenerChannel;
import pt.com.broker.types.channels.ListenerChannelFactory;
import pt.com.gcs.conf.GcsInfo;
import pt.com.gcs.messaging.Gcs;
import pt.com.gcs.messaging.SubscriptionProcessor;
import pt.com.gcs.messaging.SubscriptionProcessorList;
import pt.com.gcs.messaging.TopicProcessor;

public class TopicProcessorList
implements SubscriptionProcessorList {
    private static final TopicProcessorList instance = new TopicProcessorList();
    private static final Logger log = LoggerFactory.getLogger(TopicProcessorList.class);
    private static final AtomicLong tReceivedMessages = new AtomicLong(0L);
    private Cache<String, TopicProcessor> tpCache = new Cache();
    private static final CacheFiller<String, TopicProcessor> tp_cf = new CacheFiller<String, TopicProcessor>(){

        public TopicProcessor populate(String destinationName) {
            try {
                if (instance.tpCache.size() > GcsInfo.getMaxDistinctSubscriptions()) {
                    throw new MaximumDistinctSubscriptionsReachedException();
                }
                log.info("Populate TopicProcessorList with topic: '{}'", (Object)destinationName);
                TopicProcessor qp = new TopicProcessor(destinationName);
                return qp;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    };

    private static final void newTopicMessageReceived() {
        tReceivedMessages.incrementAndGet();
    }

    public static long getTopicMessagesReceivedAndReset() {
        return tReceivedMessages.getAndSet(0L);
    }

    public static void broadcast(String action, Channel channel) {
        instance.i_broadcast(action, channel);
    }

    public static TopicProcessor get(String destinationName) {
        return instance.i_get(destinationName);
    }

    public static void notify(NetPublish np, boolean localOnly) {
        instance.i_notify(np, localOnly);
    }

    public static void removeListener(MessageListener listener) {
        instance.i_removeListener(listener);
    }

    public static void removeSession(ChannelHandlerContext context) {
        instance.i_removeSession(context);
    }

    public static Collection<TopicProcessor> values() {
        return instance.i_values();
    }

    public static SubscriptionProcessorList getInstance() {
        return instance;
    }

    private TopicProcessorList() {
    }

    private void i_broadcast(String action, Channel channel) {
        try {
            for (TopicProcessor tp : this.tpCache.values()) {
                if (!tp.isBroadcastable() || !tp.hasLocalConsumers()) continue;
                tp.broadCastTopicInfo(action, channel);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private TopicProcessor i_get(String destinationName) {
        try {
            return (TopicProcessor)this.tpCache.get((Object)destinationName, tp_cf);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ie);
        }
        catch (MaximumDistinctSubscriptionsReachedException mdsre) {
            try {
                this.tpCache.remove((Object)destinationName);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(ie);
            }
            Gcs.broadcastMaxDistinctSubscriptionsReached();
        }
        catch (Throwable t) {
            Throwable rootCause = ErrorAnalyser.findRootCause((Throwable)t);
            CriticalErrors.exitIfCritical((Throwable)rootCause);
            log.error(String.format("Failed to get TopicProcessor for topic '%s'. Message: %s", destinationName, rootCause.getMessage()));
            if (rootCause.getClass().isAssignableFrom(MaximumDistinctSubscriptionsReachedException.class)) {
                try {
                    this.tpCache.remove((Object)destinationName);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.error("Failed to removed topic processor entry that caused  MaxDistinctSubscriptionsReached. Reason: '{}'", (Throwable)e);
                }
                Gcs.broadcastMaxDistinctSubscriptionsReached();
            }
            throw new RuntimeException(rootCause);
        }
        return null;
    }

    private void i_notify(NetPublish np, boolean localOnly) {
        try {
            TopicProcessorList.newTopicMessageReceived();
            HashSet<ListenerChannel> remoteListenersTouched = new HashSet<ListenerChannel>();
            for (TopicProcessor tp : this.tpCache.values()) {
                tp.notify(np, localOnly, remoteListenersTouched);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private void i_removeListener(MessageListener listener) {
        try {
            for (TopicProcessor tp : this.tpCache.values()) {
                if (!tp.getSubscriptionName().equals(listener.getsubscriptionKey())) continue;
                tp.remove(listener);
                break;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private void i_removeSession(ChannelHandlerContext context) {
        try {
            ListenerChannel lc = ListenerChannelFactory.getListenerChannel((ChannelHandlerContext)context);
            ArrayList<TopicProcessor> toDeleteProcessors = new ArrayList<TopicProcessor>();
            for (TopicProcessor tp : this.tpCache.values()) {
                ArrayList<MessageListener> toDeleteListeners = new ArrayList<MessageListener>();
                for (MessageListener ml : tp.listeners()) {
                    if (ml.getType() == MessageListener.Type.INTERNAL || !ml.getChannel().equals((Object)lc)) continue;
                    toDeleteListeners.add(ml);
                }
                for (MessageListener dml : toDeleteListeners) {
                    tp.remove(dml);
                }
                toDeleteListeners.clear();
                if (tp.size() != 0) continue;
                toDeleteProcessors.add(tp);
            }
            for (TopicProcessor tpd : toDeleteProcessors) {
                if (tpd.size() != 0) continue;
                this.tpCache.remove((Object)tpd.getSubscriptionName());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private Collection<TopicProcessor> i_values() {
        try {
            return this.tpCache.values();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ie);
        }
    }

    @Override
    public SubscriptionProcessor getSubscriptionProcessor(String name) {
        return this.i_get(name);
    }

    @Override
    public Collection<SubscriptionProcessor> getValues() {
        return this.i_values();
    }

    public static class MaximumDistinctSubscriptionsReachedException
    extends RuntimeException {
        private static final long serialVersionUID = 8022131893392381671L;

        @Override
        public String getMessage() {
            return "Maximum distinct subscriptions reached";
        }
    }
}

