/*
 * Decompiled with CFR 0.152.
 */
package pt.com.gcs.messaging;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.types.DeliverableMessage;
import pt.com.broker.types.ForwardResult;
import pt.com.broker.types.MessageListener;
import pt.com.broker.types.MessageListenerEventChangeHandler;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetMessage;
import pt.com.broker.types.NetNotification;
import pt.com.broker.types.channels.ListenerChannel;
import pt.com.gcs.messaging.Gcs;

class TopicToQueueDispatcher
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(TopicToQueueDispatcher.class);
    private static final ForwardResult success = new ForwardResult(ForwardResult.Result.SUCCESS);
    private static final ForwardResult failed = new ForwardResult(ForwardResult.Result.FAILED);
    private final String destinationQueueName;
    private final String topicSubscriptionKey;

    public TopicToQueueDispatcher(ListenerChannel lchannel, String topicSubscriptionKey, String destinationQueueName) {
        this.topicSubscriptionKey = topicSubscriptionKey;
        this.destinationQueueName = destinationQueueName;
    }

    public NetAction.DestinationType getSourceDestinationType() {
        return NetAction.DestinationType.TOPIC;
    }

    public NetAction.DestinationType getTargetDestinationType() {
        return NetAction.DestinationType.QUEUE;
    }

    public ForwardResult onMessage(DeliverableMessage msg) {
        if (msg instanceof NetMessage) {
            NetMessage nmsg = (NetMessage)msg;
            NetNotification nnot_orig = nmsg.getAction().getNotificationMessage();
            NetNotification nnot_fwd = new NetNotification(this.destinationQueueName, NetAction.DestinationType.QUEUE, nnot_orig.getMessage(), this.destinationQueueName);
            NetAction action_fwd = new NetAction(NetAction.ActionType.NOTIFICATION);
            action_fwd.setNotificationMessage(nnot_fwd);
            NetMessage nmsg_fwd = new NetMessage(action_fwd);
            nmsg_fwd.getHeaders().putAll(nmsg.getHeaders());
            nmsg_fwd.getHeaders().put("ORIGINAL_DESTINATION", nnot_orig.getDestination());
            if (!this.isFromRemotePeer(nmsg)) {
                Gcs.enqueue(nmsg_fwd, this.destinationQueueName);
                return success;
            }
        } else {
            log.error("Don't know how to handle message");
        }
        return failed;
    }

    private boolean isFromRemotePeer(NetMessage nmsg) {
        if (nmsg.getHeaders() != null) {
            return Boolean.parseBoolean((String)nmsg.getHeaders().get("IS_REMOTE"));
        }
        return false;
    }

    public String getsubscriptionKey() {
        return this.topicSubscriptionKey;
    }

    public boolean isReady() {
        return true;
    }

    public boolean isActive() {
        return true;
    }

    public ListenerChannel getChannel() {
        return null;
    }

    public boolean isAckRequired() {
        return false;
    }

    public MessageListener.Type getType() {
        return MessageListener.Type.INTERNAL;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.destinationQueueName == null ? 0 : this.destinationQueueName.hashCode());
        result = 31 * result + (this.topicSubscriptionKey == null ? 0 : this.topicSubscriptionKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TopicToQueueDispatcher other = (TopicToQueueDispatcher)obj;
        if (this.destinationQueueName == null ? other.destinationQueueName != null : !this.destinationQueueName.equals(other.destinationQueueName)) {
            return false;
        }
        return !(this.topicSubscriptionKey == null ? other.topicSubscriptionKey != null : !this.topicSubscriptionKey.equals(other.topicSubscriptionKey));
    }

    public String toString() {
        return "TopicToQueueDispatcher [type=" + this.getType().toString() + ", destinationQueueName=" + this.destinationQueueName + ", topicSubscriptionKey=" + this.topicSubscriptionKey + "]";
    }

    public void addStateChangeListener(MessageListenerEventChangeHandler handler) {
    }

    public void removeStateChangeListener(MessageListenerEventChangeHandler handler) {
    }
}

