/*
 * Decompiled with CFR 0.152.
 */
package pt.com.gcs.messaging;

import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.Environment;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.util.ArrayList;
import org.caudexorigo.ErrorAnalyser;
import org.caudexorigo.Shutdown;
import org.caudexorigo.cryto.MD5;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.types.CriticalErrors;
import pt.com.gcs.messaging.BDBEnviroment;
import pt.com.gcs.messaging.BDBStorage;

public class VirtualQueueStorage {
    private static Logger log = LoggerFactory.getLogger(BDBStorage.class);
    private static final VirtualQueueStorage instance = new VirtualQueueStorage();
    private Environment env;
    private Database vqStorage;
    private String dbName;

    private VirtualQueueStorage() {
        try {
            this.env = BDBEnviroment.get();
            this.dbName = MD5.getHashString((String)"VirtualQueueStorage");
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setTransactional(true);
            dbConfig.setAllowCreate(true);
            dbConfig.setSortedDuplicates(false);
            this.vqStorage = this.env.openDatabase(null, this.dbName, dbConfig);
            log.info("VirtualQueueStorage is ready.");
        }
        catch (Throwable t) {
            Throwable rt = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(rt.getMessage(), rt);
            Shutdown.now();
        }
    }

    private void i_saveVirtualQueue(String queueName) {
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            StringBinding.stringToEntry((String)queueName, (DatabaseEntry)key);
            StringBinding.stringToEntry((String)queueName, (DatabaseEntry)data);
            Transaction txn = this.env.beginTransaction(null, null);
            this.vqStorage.put(txn, key, data);
            txn.commitSync();
        }
        catch (Throwable t) {
            Throwable rt = ErrorAnalyser.findRootCause((Throwable)t);
            CriticalErrors.exitIfCritical((Throwable)rt);
            log.error(rt.getMessage(), rt);
        }
    }

    private void i_deleteVirtualQueue(String queueName) {
        try {
            DatabaseEntry key = new DatabaseEntry();
            StringBinding.stringToEntry((String)queueName, (DatabaseEntry)key);
            Transaction txn = this.env.beginTransaction(null, null);
            this.vqStorage.delete(txn, key);
            txn.commitSync();
        }
        catch (Throwable t) {
            Throwable rt = ErrorAnalyser.findRootCause((Throwable)t);
            CriticalErrors.exitIfCritical((Throwable)rt);
            log.error(rt.getMessage(), rt);
        }
    }

    protected static synchronized void saveVirtualQueue(String queueName) {
        instance.i_saveVirtualQueue(queueName);
    }

    protected static void deleteVirtualQueue(String queueName) {
        instance.i_deleteVirtualQueue(queueName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] i_getVirtualQueueNames() {
        Cursor cursor = null;
        try {
            String[] qname;
            ArrayList<String[]> lst = new ArrayList<String[]>();
            cursor = this.vqStorage.openCursor(null, null);
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            while (cursor.getNext(key, data, null) == OperationStatus.SUCCESS) {
                qname = StringBinding.entryToString((DatabaseEntry)data);
                lst.add(qname);
            }
            qname = lst.toArray(new String[lst.size()]);
            return qname;
        }
        catch (Throwable t) {
            Throwable rt = ErrorAnalyser.findRootCause((Throwable)t);
            CriticalErrors.exitIfCritical((Throwable)rt);
            log.error(rt.getMessage(), rt);
            String[] stringArray = new String[]{};
            return stringArray;
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Throwable t) {
                    Throwable rt = ErrorAnalyser.findRootCause((Throwable)t);
                    CriticalErrors.exitIfCritical((Throwable)rt);
                    log.error(rt.getMessage(), rt);
                }
            }
        }
    }

    protected static String[] getVirtualQueueNames() {
        return instance.i_getVirtualQueueNames();
    }
}

