/*
 * Decompiled with CFR 0.152.
 */
package pt.com.gcs.messaging.serialization;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.caudexorigo.io.UnsynchronizedByteArrayInputStream;
import org.caudexorigo.io.UnsynchronizedByteArrayOutputStream;
import pt.com.broker.codec.protobuf.ProtoBufBindingSerializer;
import pt.com.broker.types.NetMessage;
import pt.com.gcs.messaging.BDBMessage;
import pt.com.gcs.messaging.serialization.Codec;

public class BDBMessageMarshallerV2
implements Codec<BDBMessage> {
    private static final ProtoBufBindingSerializer serializer = new ProtoBufBindingSerializer();

    @Override
    public byte[] marshall(BDBMessage bdbMessage) {
        try {
            UnsynchronizedByteArrayOutputStream bout = new UnsynchronizedByteArrayOutputStream();
            ObjectOutputStream oout = new ObjectOutputStream((OutputStream)bout);
            oout.writeShort(bdbMessage.getVersion());
            oout.writeLong(bdbMessage.getSequence());
            oout.writeBoolean(bdbMessage.getPreferLocalConsumer());
            oout.writeLong(bdbMessage.getReserveTimeout());
            if (bdbMessage.getRawPacket() == null) {
                serializer.marshal(bdbMessage.getMessage(), (OutputStream)oout);
            } else {
                oout.write(bdbMessage.getRawPacket());
            }
            oout.flush();
            return bout.toByteArray();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public BDBMessage unmarshall(byte[] data) throws Throwable {
        BDBMessage message = new BDBMessage();
        try (ObjectInputStream oIn = new ObjectInputStream((InputStream)new UnsynchronizedByteArrayInputStream(data));){
            short version = oIn.readShort();
            if (version != 2) {
                String errorMessage = String.format("Incorrect serialization version: ", version);
                throw new RuntimeException(errorMessage);
            }
            message.setVersion(version);
            message.setSequence(oIn.readLong());
            message.setPreferLocalConsumer(oIn.readBoolean());
            message.setReserveTimeout(oIn.readLong());
            NetMessage nmsg = serializer.unmarshal((InputStream)oIn);
            message.setMessage(nmsg);
            BDBMessage bDBMessage = message;
            return bDBMessage;
        }
    }
}

