/*
 * Decompiled with CFR 0.152.
 */
package pt.com.gcs.messaging.statistics;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.types.MessageListener;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetBrokerMessage;
import pt.com.broker.types.NetPublish;
import pt.com.gcs.conf.GcsInfo;
import pt.com.gcs.messaging.Gcs;
import pt.com.gcs.messaging.QueueProcessor;
import pt.com.gcs.messaging.QueueProcessorList;
import pt.com.gcs.messaging.TopicProcessor;
import pt.com.gcs.messaging.TopicProcessorList;
import pt.sapo.socialbus.common.kpi.EventBuilder;
import pt.sapo.socialbus.common.kpi.data.Event;
import pt.sapo.socialbus.common.kpi.data.MetricItem;
import pt.sapo.socialbus.common.kpi.data.MetricType;

public abstract class KpiStatistics {
    private static final Logger log = LoggerFactory.getLogger(KpiStatistics.class);

    public static final void publishKpiEvents(List<Event> events) {
        log.debug("Publishing #{} KpiEvents.", (Object)events.size());
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        for (Event event : events) {
            try {
                NetPublish np = new NetPublish("/sapo/event-agg-kpi", NetAction.DestinationType.TOPIC, new NetBrokerMessage(objectMapper.writeValueAsString((Object)event)));
                Gcs.publish(np);
            }
            catch (JsonProcessingException e) {
                log.error("Error encoding event object to json. Event object: {}", (Object)event.toString(), (Object)e);
            }
        }
    }

    private static final EventBuilder getEventBuilder(String destinationType) {
        EventBuilder eventBuilder = new EventBuilder().setTimestamp(Long.valueOf(new Date().getTime())).setDomain("broker.bk.sapo.pt").addStringAttribute("agent-name", GcsInfo.getAgentName());
        if (destinationType != null) {
            eventBuilder.addStringAttribute("destination-type", destinationType);
        }
        return eventBuilder;
    }

    public static final List<Event> getKpiTopicListeners() {
        ArrayList events = Lists.newArrayList();
        for (TopicProcessor tp : TopicProcessorList.values()) {
            EventBuilder eventBuilder = KpiStatistics.getEventBuilder(NetAction.DestinationType.TOPIC.toString());
            int localListeners = 0;
            for (MessageListener listener : tp.listeners()) {
                if (listener.getType() != MessageListener.Type.LOCAL) continue;
                ++localListeners;
            }
            if (localListeners <= 0) continue;
            eventBuilder.addStringAttribute("topic-name", tp.getSubscriptionName());
            eventBuilder.addMetricItem(new MetricItem(MetricType.counter, "subscriptions", Double.valueOf(localListeners)));
            events.add(eventBuilder.buildMetricBundleEvent());
        }
        return events;
    }

    public static final List<Event> getKpiQueueListeners() {
        ArrayList events = Lists.newArrayList();
        for (QueueProcessor qp : QueueProcessorList.values()) {
            EventBuilder eventBuilder = KpiStatistics.getEventBuilder(NetAction.DestinationType.QUEUE.toString());
            if (qp.localListeners().size() <= 0) continue;
            eventBuilder.addStringAttribute("queue-name", qp.getQueueName());
            eventBuilder.addMetricItem(new MetricItem(MetricType.counter, "subscriptions", Double.valueOf(qp.localListeners().size())));
            events.add(eventBuilder.buildMetricBundleEvent());
        }
        return events;
    }

    public static final List<Event> getQueuesList() {
        ArrayList events = Lists.newArrayList();
        return events;
    }

    public static final List<Event> getQueuesSize() {
        ArrayList events = Lists.newArrayList();
        for (QueueProcessor qp : QueueProcessorList.values()) {
            EventBuilder eventBuilder = KpiStatistics.getEventBuilder(NetAction.DestinationType.QUEUE.toString());
            eventBuilder.addStringAttribute("queue-name", qp.getQueueName());
            eventBuilder.addMetricItem(new MetricItem(MetricType.counter, "queued-messages", Double.valueOf(qp.getQueuedMessagesCount())));
            events.add(eventBuilder.buildMetricBundleEvent());
        }
        return events;
    }
}

