/*
 * Decompiled with CFR 0.152.
 */
package pt.com.gcs.net;

import org.apache.commons.lang3.StringUtils;

public class Peer {
    private final String _name;
    private final String _host;
    private final int _port;
    private final String _address;

    public Peer(String name, String host, int port) {
        this(name, host, port, host + ":" + port);
    }

    public Peer(String name, String host, int port, String address) {
        this._name = name;
        this._host = host;
        this._port = port;
        this._address = address;
    }

    public String getName() {
        return this._name;
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public String getAddress() {
        return this._address;
    }

    public static Peer createPeerFromHelloMessage(String helloMessage) {
        String peerName = StringUtils.substringBefore((String)helloMessage, (String)"@");
        String peerAddr = StringUtils.substringAfter((String)helloMessage, (String)"@");
        String peerHost = StringUtils.substringBefore((String)peerAddr, (String)":");
        try {
            int peerPort = Integer.parseInt(StringUtils.substringAfter((String)peerAddr, (String)":"));
            return new Peer(peerName, peerHost, peerPort, peerAddr);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._host == null ? 0 : this._host.hashCode());
        result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
        result = 31 * result + this._port;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Peer other = (Peer)obj;
        if (this._host == null ? other._host != null : !this._host.equals(other._host)) {
            return false;
        }
        if (this._name == null ? other._name != null : !this._name.equals(other._name)) {
            return false;
        }
        return this._port == other._port;
    }

    public String toString() {
        return this._name + "#" + this._host + ":" + this._port;
    }
}

