/*
 * Decompiled with CFR 0.152.
 */
package pt.com.gcs.net.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.codec.protobuf.ProtoBufBindingSerializer;
import pt.com.broker.types.NetMessage;

public class GcsCodec
extends ByteToMessageCodec<NetMessage> {
    private static final Logger log = LoggerFactory.getLogger(GcsCodec.class);
    public static final int HEADER_LENGTH = 4;
    private final ProtoBufBindingSerializer serializer = new ProtoBufBindingSerializer();

    protected void encode(ChannelHandlerContext ctx, NetMessage msg, ByteBuf out) throws Exception {
        byte[] buffer = this.serializer.marshal(msg);
        out.writeInt(buffer.length);
        out.writeBytes(buffer);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        int readableBytes = in.readableBytes();
        if (readableBytes >= 4) {
            int len = in.readInt();
            if (len <= 0) {
                log.error(String.format("Illegal message size!! Received message claimed to have %s bytes.", len));
                ctx.close();
            }
            if (readableBytes >= len + 4) {
                byte[] decoded = new byte[len];
                in.readBytes(decoded);
                NetMessage msg = this.serializer.unmarshal(decoded);
                out.add(msg);
            }
        }
    }
}

