/*
 * Decompiled with CFR 0.152.
 */
package pt.com.gcs.net.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.codec.protobuf.ProtoBufBindingSerializer;
import pt.com.broker.types.NetMessage;

public class GcsDecoder
extends ByteToMessageDecoder {
    private static final Logger log = LoggerFactory.getLogger(GcsDecoder.class);
    private static final int HEADER_LENGTH = 4;
    private final ProtoBufBindingSerializer serializer = new ProtoBufBindingSerializer();

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        int readableBytes = buffer.readableBytes();
        if (readableBytes >= 4) {
            int len = buffer.readInt();
            if (len <= 0) {
                log.error(String.format("Illegal message size!! Received message claimed to have %s bytes.", len));
                ctx.close();
            }
            if (readableBytes >= len + 4) {
                byte[] decoded = new byte[len];
                buffer.readBytes(decoded);
                NetMessage msg = this.serializer.unmarshal(decoded);
                out.add(msg);
            }
        }
    }
}

