/*
 * Decompiled with CFR 0.152.
 */
package pt.com.gcs.net.ssl;

import io.netty.handler.ssl.SslContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import pt.com.gcs.conf.GcsInfo;

public final class SslContextFactory {
    public static final SSLContext getServerContext() throws NoSuchAlgorithmException, KeyStoreException, CertificateException, FileNotFoundException, IOException, UnrecoverableKeyException, KeyManagementException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        String keyStoreLocation = GcsInfo.getKeystoreLocation();
        String keyStorePasswordStr = GcsInfo.getKeystorePassword();
        String keyPasswordStr = GcsInfo.getKeyPassword();
        SSLContext context = SSLContext.getInstance("TLSv1");
        char[] KEYSTOREPW = keyStorePasswordStr.toCharArray();
        char[] KEYPW = keyPasswordStr != null ? keyPasswordStr.toCharArray() : null;
        File ks = new File(keyStoreLocation);
        keyStore.load(new FileInputStream(ks), KEYSTOREPW);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keyStore, KEYPW);
        context.init(kmf.getKeyManagers(), null, null);
        return context;
    }

    public static final SslContext getServerSslContext(String certPath, String keyPath, String keyPasswd) throws SSLException {
        return SslContext.newServerContext((File)new File(certPath), (File)new File(keyPath), (String)keyPasswd);
    }

    public static final SslContext getClientSslContext() throws SSLException, NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init((KeyStore)null);
        return SslContext.newClientContext((TrustManagerFactory)tmf);
    }
}

