/*
 * Decompiled with CFR 0.152.
 */
package pt.com.gcs.conf;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.lang3.StringUtils;
import org.caudexorigo.Shutdown;
import org.caudexorigo.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.auth.ProviderInfo;
import pt.com.gcs.conf.GlobalConfig;
import pt.com.gcs.conf.agent.AgentConfig;
import pt.com.gcs.conf.global.BrokerSecurityPolicy;

public class GcsInfo {
    private static final Logger log = LoggerFactory.getLogger(GcsInfo.class);
    public static final int UNLIMITED_QUEUES_VALUE = -1;
    private static final GcsInfo instance = new GcsInfo();
    private AgentConfig conf;
    private String agentName;

    public static String constructAgentName(String ip, int port) {
        return ip + ":" + port;
    }

    public static boolean createSSLInterface() {
        return GcsInfo.instance.conf.getSsl() != null;
    }

    public static String getAgentHost() {
        String prop = GcsInfo.instance.conf.getNet().getIp();
        if (StringUtils.isBlank((CharSequence)prop)) {
            log.error("Fatal error: Must define valid host.");
            Shutdown.now();
        }
        return prop;
    }

    public static String getAgentName() {
        return GcsInfo.instance.agentName;
    }

    public static int getAgentPort() {
        int iprop = GcsInfo.instance.conf.getNet().getPort();
        return iprop;
    }

    public static String getBasePersistentDirectory() {
        String prop = GcsInfo.instance.conf.getPersistency().getDirectory();
        String defaultDir = FilenameUtils.normalizeNoEndSeparator((String)System.getProperty("user.dir")) + File.separator + "persistent";
        if (StringUtils.isBlank((CharSequence)prop)) {
            log.warn("No directory for persistent storage. Using default: {}", (Object)defaultDir);
            return defaultDir;
        }
        return FilenameUtils.normalizeNoEndSeparator((String)prop);
    }

    public static int getBrokerHttpPort() {
        int iprop = GcsInfo.instance.conf.getNet().getBrokerHttpPort();
        return iprop;
    }

    public static int getBrokerWsPort() {
        int iprop = GcsInfo.instance.conf.getNet().getBrokerWsPort();
        return iprop;
    }

    public static int getBrokerLegacyPort() {
        int iprop = GcsInfo.instance.conf.getNet().getBrokerLegacyPort();
        return iprop;
    }

    public static int getBrokerPort() {
        int iprop = GcsInfo.instance.conf.getNet().getBrokerPort();
        return iprop;
    }

    public static int getBrokerSSLPort() {
        AgentConfig.Ssl ssl = GcsInfo.instance.conf.getSsl();
        if (ssl == null) {
            return -1;
        }
        int sslPort = ssl.getBrokerSslPort();
        return sslPort;
    }

    public static int getBrokerUdpPort() {
        int iprop = GcsInfo.instance.conf.getNet().getBrokerUdpPort();
        return iprop;
    }

    public static String getConfigVersion() {
        String prop = GcsInfo.instance.conf.getConfigVersion();
        return prop;
    }

    public static Map<String, ProviderInfo> getCredentialValidatorProviders() {
        return GlobalConfig.getCredentialValidatorProviders();
    }

    public static int getDropBoxCheckInterval() {
        return GcsInfo.instance.conf.getMessaging().getDropbox().getCheckInterval();
    }

    public static String getDropBoxDir() {
        return GcsInfo.instance.conf.getMessaging().getDropbox().getDir();
    }

    public static String getGlobalConfigFilePath() {
        String prop = System.getProperty("broker-global-config-path");
        if (StringUtils.isBlank((CharSequence)prop)) {
            log.error("Fatal error: No global configuration file defined. Please set the enviroment variable 'broker-global-config-path' to valid path for the global configuration file");
            Shutdown.now();
        }
        return prop;
    }

    public static int getInitialDelay() {
        int iprop = GcsInfo.instance.conf.getNet().getDiscoveryDelay();
        return iprop;
    }

    public static String getKeyPassword() {
        if (GcsInfo.instance.conf.getSsl() != null) {
            return GcsInfo.instance.conf.getSsl().getKeyPassword();
        }
        return null;
    }

    public static String getKeystoreLocation() {
        if (GcsInfo.instance.conf.getSsl() != null) {
            return GcsInfo.instance.conf.getSsl().getKeystoreLocation();
        }
        return null;
    }

    public static String getKeystorePassword() {
        if (GcsInfo.instance.conf.getSsl() != null) {
            return GcsInfo.instance.conf.getSsl().getKeystorePassword();
        }
        return null;
    }

    public static int getMaxDistinctSubscriptions() {
        return GlobalConfig.getMaxDistinctSubscriptions();
    }

    public static int getMaxQueues() {
        return GlobalConfig.getMaxQueues();
    }

    public static long getQueueMaxStaleAge() {
        return GlobalConfig.getQueueMaxStaleAge();
    }

    public static int getMessageMaxSize() {
        return GlobalConfig.getMsgMaxSize();
    }

    public static long getMessageStorageTime() {
        return GlobalConfig.getMaxStoreTime();
    }

    public static BrokerSecurityPolicy getSecurityPolicies() {
        return GlobalConfig.getSecurityPolicies();
    }

    public static boolean isDropboxEnabled() {
        return GcsInfo.instance.conf.getMessaging().getDropbox().isEnabled();
    }

    public static boolean useAccessControl() {
        return GcsInfo.getSecurityPolicies() != null;
    }

    public static boolean isForceAgentSsl() {
        return GcsInfo.instance.conf.getSsl().getForceAgentSsl();
    }

    public static String getSslProtocolWhiteList() {
        return GcsInfo.instance.conf.getSsl().getSslProtocolWhiteList();
    }

    public static String getSslCipherSuiteWhitelist() {
        return GcsInfo.instance.conf.getSsl().getSslCipherSuiteWhiteList();
    }

    public static String getCertificateFile() {
        return GcsInfo.instance.conf.getSsl().getCertFile();
    }

    public static String getKeyFile() {
        return GcsInfo.instance.conf.getSsl().getKeyFile();
    }

    private GcsInfo() {
        String filePath = System.getProperty("agent-config-path");
        if (StringUtils.isBlank((CharSequence)filePath)) {
            log.error("Fatal error: No agent configuration file defined. Please set the enviroment variable 'agent-config-path' to valid path for the configuration file");
            Shutdown.now();
        }
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"pt.com.gcs.conf.agent");
            Unmarshaller u = jc.createUnmarshaller();
            log.debug("******************Current path: {}***********************", (Object)Paths.get(".", new String[0]).toAbsolutePath().normalize().toString());
            URL fileUrl = this.getClass().getClassLoader().getResource(filePath);
            File f = null;
            if (fileUrl != null) {
                f = new File(fileUrl.toURI());
            } else {
                f = new File(filePath);
                if (!f.exists()) {
                    f = new File(Paths.get(".", new String[0]).resolve(filePath).toAbsolutePath().normalize().toString());
                }
            }
            boolean b = f.exists();
            if (!b) {
                log.error("Agent configuration file missing - " + filePath);
                Shutdown.now();
            }
            this.conf = (AgentConfig)u.unmarshal(f);
            String prop = GcsInfo.constructAgentName(this.conf.getNet().getIp(), this.conf.getNet().getPort());
            if (StringUtils.isBlank((CharSequence)prop)) {
                log.error("Fatal error: Must define an Agent name.");
                Shutdown.now();
            }
            this.agentName = prop;
        }
        catch (URISyntaxException | JAXBException e) {
            log.error("Fatal error: {}", (Object)e.getMessage());
            Shutdown.now((Throwable)e);
        }
    }
}

