/*
 * Decompiled with CFR 0.152.
 */
package pt.com.gcs.messaging;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.caudexorigo.ErrorAnalyser;
import org.caudexorigo.Shutdown;
import org.caudexorigo.cryto.MD5;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.types.CriticalErrors;
import pt.com.gcs.conf.GcsInfo;

public class BDBEnviroment {
    private static Logger log = LoggerFactory.getLogger(BDBEnviroment.class);
    private Environment env;
    private String dbFile;
    private String dbDir;
    private static final BDBEnviroment instance = new BDBEnviroment();

    private BDBEnviroment() {
        try {
            this.dbFile = GcsInfo.getBasePersistentDirectory();
            this.dbDir = this.dbFile.concat(File.separator);
            new File(this.dbDir).mkdirs();
            EnvironmentConfig envConfig = new EnvironmentConfig();
            envConfig.setAllowCreate(true);
            envConfig.setTransactional(true);
            envConfig.setCachePercent(40);
            log.info("Persistence directory: {}", (Object)this.dbDir);
            this.env = new Environment(new File(this.dbDir), envConfig);
        }
        catch (Throwable t) {
            Throwable rt = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(rt.getMessage(), rt);
            Shutdown.now();
        }
    }

    public static Environment get() {
        return BDBEnviroment.instance.env;
    }

    public static void sync() {
        try {
            BDBEnviroment.instance.env.sync();
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static String[] getQueueNames() {
        try {
            List in_lst = BDBEnviroment.instance.env.getDatabaseNames();
            ArrayList<String> out_lst = new ArrayList<String>();
            String nonQueue = MD5.getHashString((String)"VirtualQueueStorage");
            for (String dbName : in_lst) {
                if (dbName.equals(nonQueue)) continue;
                out_lst.add(dbName);
            }
            return out_lst.toArray(new String[out_lst.size()]);
        }
        catch (Throwable t) {
            Throwable rt = ErrorAnalyser.findRootCause((Throwable)t);
            CriticalErrors.exitIfCritical((Throwable)rt);
            log.error(rt.getMessage(), rt);
            return new String[0];
        }
    }
}

