/*
 * Decompiled with CFR 0.152.
 */
package pt.com.gcs.messaging;

import com.sleepycat.bind.ByteArrayBinding;
import com.sleepycat.bind.tuple.LongBinding;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.OperationStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.caudexorigo.ErrorAnalyser;
import org.caudexorigo.Shutdown;
import org.caudexorigo.concurrent.Sleep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.types.CriticalErrors;
import pt.com.broker.types.ForwardResult;
import pt.com.broker.types.NetMessage;
import pt.com.gcs.messaging.BDBEnviroment;
import pt.com.gcs.messaging.BDBMessage;
import pt.com.gcs.messaging.BDBMessageComparator;
import pt.com.gcs.messaging.QueueProcessor;
import pt.com.gcs.messaging.serialization.MessageMarshaller;

public class BDBStorage {
    private static Logger log = LoggerFactory.getLogger(BDBStorage.class);
    private static final int MAX_REDELIVERY_PER_MESSAGE = 3;
    private Environment env;
    private Database messageDb;
    private String primaryDbName;
    private QueueProcessor queueProcessor;
    private final AtomicBoolean isMarkedForDeletion = new AtomicBoolean(false);
    protected AtomicBoolean recoveryRunning = new AtomicBoolean(false);

    public BDBStorage(QueueProcessor qp) {
        try {
            if (this.isMarkedForDeletion.get()) {
                return;
            }
            this.queueProcessor = qp;
            this.primaryDbName = this.queueProcessor.getQueueName();
            this.env = BDBEnviroment.get();
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setTransactional(false);
            dbConfig.setAllowCreate(true);
            dbConfig.setSortedDuplicates(false);
            dbConfig.setBtreeComparator(BDBMessageComparator.class);
            this.messageDb = this.env.openDatabase(null, this.primaryDbName, dbConfig);
            log.info("Storage for queue '{}' is ready.", (Object)this.queueProcessor.getQueueName());
        }
        catch (Throwable t) {
            this.dealWithError(t, false);
            Shutdown.now();
        }
    }

    private DatabaseEntry buildDatabaseEntry(BDBMessage bdbm) {
        DatabaseEntry data = new DatabaseEntry();
        ByteArrayBinding bab = new ByteArrayBinding();
        byte[] marshallBDBMessage = MessageMarshaller.marshallBDBMessage(bdbm);
        if (marshallBDBMessage != null) {
            bab.objectToEntry(marshallBDBMessage, data);
            return data;
        }
        throw new RuntimeException("MessageMarshaller.marshallBDBMessage returned null");
    }

    private void closeDatabase(Database db) {
        try {
            String dbName = db.getDatabaseName();
            log.debug("Try to close db '{}'", (Object)dbName);
            db.close();
            log.debug("Closed db '{}'", (Object)dbName);
        }
        catch (Throwable t) {
            this.dealWithError(t, false);
        }
    }

    private void closeDbCursor(Cursor msg_cursor) {
        if (msg_cursor != null) {
            try {
                msg_cursor.close();
            }
            catch (Throwable t) {
                this.dealWithError(t, false);
            }
        }
    }

    private void cursorDelete(Cursor msg_cursor) throws DatabaseException {
        msg_cursor.delete();
        this.queueProcessor.decrementQueuedMessagesCount();
    }

    private void dealWithError(Throwable t, boolean rethrow) {
        Throwable rt = ErrorAnalyser.findRootCause((Throwable)t);
        log.error(rt.getMessage(), rt);
        CriticalErrors.exitIfCritical((Throwable)rt);
        if (rethrow) {
            throw new RuntimeException(rt);
        }
    }

    private void removeDatabase(String dbName) {
        for (int retryCount = 0; retryCount < 5; ++retryCount) {
            try {
                log.debug("Try to remove db '{}'", (Object)dbName);
                this.env.truncateDatabase(null, dbName, false);
                this.env.removeDatabase(null, dbName);
                log.debug("Storage for queue '{}' was removed", (Object)this.queueProcessor.getQueueName());
                break;
            }
            catch (Throwable t) {
                log.error(t.getMessage());
                Sleep.time((long)2500L);
                continue;
            }
        }
    }

    protected long count() {
        if (this.isMarkedForDeletion.get()) {
            return 0L;
        }
        try {
            return this.messageDb.count();
        }
        catch (DatabaseException e) {
            this.dealWithError(e, false);
            return 0L;
        }
    }

    protected boolean deleteMessage(String msgId) {
        if (this.isMarkedForDeletion.get()) {
            return false;
        }
        DatabaseEntry key = new DatabaseEntry();
        long k = Long.parseLong(msgId.substring(33));
        LongBinding.longToEntry((long)k, (DatabaseEntry)key);
        int count = 5;
        LockConflictException lastDeadlockException = null;
        do {
            try {
                OperationStatus op = this.messageDb.delete(null, key);
                return op.equals((Object)OperationStatus.SUCCESS);
            }
            catch (LockConflictException de) {
                lastDeadlockException = de;
                log.error("DeadlockException. Number of retries left: " + --count, (Throwable)de);
            }
            catch (DatabaseException e) {
                this.dealWithError(e, true);
                return false;
            }
        } while (count != 0);
        this.dealWithError(lastDeadlockException, true);
        return false;
    }

    protected void deleteQueue() {
        this.isMarkedForDeletion.set(true);
        this.closeDatabase(this.messageDb);
        this.removeDatabase(this.primaryDbName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getLastSequenceValue() {
        if (this.isMarkedForDeletion.get()) {
            return 0L;
        }
        Cursor msg_cursor = null;
        long seqValue = 0L;
        try {
            msg_cursor = this.messageDb.openCursor(null, null);
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            msg_cursor.getLast(key, data, null);
            seqValue = LongBinding.entryToLong((DatabaseEntry)key);
            this.closeDbCursor(msg_cursor);
        }
        catch (Throwable t) {
            try {
                this.dealWithError(t, false);
                this.closeDbCursor(msg_cursor);
            }
            catch (Throwable throwable) {
                this.closeDbCursor(msg_cursor);
                throw throwable;
            }
        }
        return seqValue;
    }

    public void insert(BDBMessage bdbm) {
        if (!this.isMarkedForDeletion.get()) {
            try {
                DatabaseEntry key = new DatabaseEntry();
                DatabaseEntry data = this.buildDatabaseEntry(bdbm);
                LongBinding.longToEntry((long)bdbm.getSequence(), (DatabaseEntry)key);
                if (this.messageDb.put(null, key, data) != OperationStatus.SUCCESS) {
                    String msg = String.format("Failed to insert message in queue '%s'", this.queueProcessor.getQueueName());
                    throw new RuntimeException(msg);
                }
            }
            catch (Throwable t) {
                this.dealWithError(t, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BDBMessage> getMessages() {
        Cursor msg_cursor = null;
        ArrayList<BDBMessage> list = new ArrayList<BDBMessage>(10);
        try {
            msg_cursor = this.messageDb.openCursor(null, null);
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            while (msg_cursor.getNext(key, data, null) == OperationStatus.SUCCESS && !this.isMarkedForDeletion.get()) {
                byte[] bdata = data.getData();
                BDBMessage bdbm = null;
                try {
                    bdbm = MessageMarshaller.unmarshallBDBMessage(bdata);
                    if (bdbm == null) {
                        log.info("MessageMarshaller.unmarshallBDBMessage returned null");
                        continue;
                    }
                    list.add(bdbm);
                }
                catch (Throwable e) {}
            }
            this.closeDbCursor(msg_cursor);
        }
        catch (Exception ex) {
            try {
                log.error(ex.getMessage(), (Throwable)ex);
                this.closeDbCursor(msg_cursor);
            }
            catch (Throwable throwable) {
                this.closeDbCursor(msg_cursor);
                throw throwable;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long recoverMessages() {
        if (this.isMarkedForDeletion.get()) {
            return 0L;
        }
        boolean wasRunning = this.recoveryRunning.getAndSet(true);
        if (wasRunning) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        long nextCycle = Long.MAX_VALUE;
        int i0 = 0;
        int j0 = 0;
        int k0 = 0;
        int e0 = 0;
        int a0 = 0;
        Cursor msg_cursor = null;
        try {
            msg_cursor = this.messageDb.openCursor(null, null);
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            int countLoop = 0;
            while (msg_cursor.getNext(key, data, null) == OperationStatus.SUCCESS) {
                log.debug("Count loop: {}", (Object)(++countLoop));
                if (this.isMarkedForDeletion.get()) break;
                byte[] bdata = data.getData();
                BDBMessage bdbm = null;
                NetMessage nmsg = null;
                try {
                    bdbm = MessageMarshaller.unmarshallBDBMessage(bdata);
                    if (bdbm == null) {
                        log.info("MessageMarshaller.unmarshallBDBMessage returned null");
                        continue;
                    }
                    nmsg = bdbm.getMessage();
                }
                catch (Throwable e) {
                    log.error(e.getMessage(), e);
                    this.cursorDelete(msg_cursor);
                    continue;
                }
                boolean preferLocalConsumer = bdbm.getPreferLocalConsumer();
                long reserveTimeout = bdbm.getReserveTimeout();
                log.debug("Message reserve timeout: {}", (Object)reserveTimeout);
                log.debug("Current time: {}", (Object)now);
                boolean isReserved = reserveTimeout > now;
                if (isReserved) continue;
                long deferredDelivery = nmsg.getAction().getNotificationMessage().getMessage().getDeferredDelivery();
                if (deferredDelivery > now) {
                    long diff = deferredDelivery - now;
                    if (diff >= nextCycle) continue;
                    nextCycle = diff;
                    continue;
                }
                if (now > nmsg.getAction().getNotificationMessage().getMessage().getExpiration()) {
                    this.cursorDelete(msg_cursor);
                    ++e0;
                    continue;
                }
                try {
                    int tries = 0;
                    ForwardResult result = null;
                    do {
                        result = this.queueProcessor.forward(nmsg, preferLocalConsumer);
                    } while (result.result == ForwardResult.Result.FAILED && ++tries != 3);
                    if (result.result == ForwardResult.Result.FAILED) {
                        ++j0;
                        break;
                    }
                    if (bdbm.getReserveTimeout() != 0L) {
                        ++k0;
                        this.queueProcessor.getQueueStatistics().newQueueRedeliveredMessage();
                    }
                    if (result.result == ForwardResult.Result.SUCCESS) {
                        long time = result.time;
                        bdbm.setReserveTimeout(now + result.time);
                        msg_cursor.putCurrent(this.buildDatabaseEntry(bdbm));
                        ++i0;
                        if (time >= nextCycle) continue;
                        nextCycle = time;
                        continue;
                    }
                    this.cursorDelete(msg_cursor);
                    ++a0;
                }
                catch (Throwable t) {
                    log.error("Error recovering messages", t);
                    t.printStackTrace();
                    break;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug(String.format("Queue '%s' processing summary; Delivered: %s; Failed delivery: %s; Expired: %s; Pre ack'ed: %s; Redelivered: %s", this.queueProcessor.getQueueName(), i0, j0, e0, a0, k0));
            } else if (e0 + k0 > 0) {
                log.warn(String.format("Queue '%s' processing summary; Expired: %s; Redelivered: %s", this.queueProcessor.getQueueName(), e0, k0));
            }
            this.closeDbCursor(msg_cursor);
        }
        catch (Throwable t) {
            try {
                this.dealWithError(t, false);
                this.closeDbCursor(msg_cursor);
            }
            catch (Throwable throwable) {
                this.closeDbCursor(msg_cursor);
                throw throwable;
            }
        }
        this.recoveryRunning.set(false);
        return nextCycle != Long.MAX_VALUE ? nextCycle : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteExpiredMessages() {
        if (this.isMarkedForDeletion.get()) {
            return;
        }
        if (this.recoveryRunning.get()) {
            return;
        }
        log.info("Deleting expired messages for queue '{}'.", (Object)this.queueProcessor.getQueueName());
        long now = System.currentTimeMillis();
        int e0 = 0;
        Cursor msg_cursor = null;
        try {
            msg_cursor = this.messageDb.openCursor(null, null);
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            while (msg_cursor.getNext(key, data, null) == OperationStatus.SUCCESS && !this.isMarkedForDeletion.get()) {
                byte[] bdata = data.getData();
                BDBMessage bdbm = null;
                NetMessage msg = null;
                try {
                    bdbm = MessageMarshaller.unmarshallBDBMessage(bdata);
                    if (bdbm == null) {
                        log.info("MessageMarshaller.unmarshallBDBMessage returned null");
                        continue;
                    }
                    msg = bdbm.getMessage();
                }
                catch (Throwable e) {
                    this.cursorDelete(msg_cursor);
                    continue;
                }
                long reserveTimeout = bdbm.getReserveTimeout();
                boolean isReserved = reserveTimeout > now;
                if (isReserved || now <= msg.getAction().getNotificationMessage().getMessage().getExpiration()) continue;
                this.cursorDelete(msg_cursor);
                ++e0;
                this.queueProcessor.getQueueStatistics().newQueueExpiredMessage();
            }
            if (e0 > 0) {
                log.warn("Number of expired messages for queue '{}': {}", (Object)this.queueProcessor.getQueueName(), (Object)e0);
            }
            this.closeDbCursor(msg_cursor);
        }
        catch (Throwable t) {
            try {
                this.dealWithError(t, false);
                this.closeDbCursor(msg_cursor);
            }
            catch (Throwable throwable) {
                this.closeDbCursor(msg_cursor);
                throw throwable;
            }
        }
    }
}

