/*
 * Decompiled with CFR 0.152.
 */
package pt.com.gcs.messaging;

import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.gcs.conf.GlobalConfig;
import pt.com.gcs.messaging.Gcs;

public class GlobalConfigMonitor
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(GlobalConfigMonitor.class);
    private static List<GlobalConfigModifiedListener> listeners = new LinkedList<GlobalConfigModifiedListener>();

    @Override
    public void run() {
        log.debug("Checking world map file for modifications.");
        if (GlobalConfig.reload()) {
            Gcs.reloadWorldMap();
            GlobalConfigMonitor.fireGlobalConfigModified();
        }
    }

    public static synchronized void addGlobalConfigModifiedListener(GlobalConfigModifiedListener listener) {
        listeners.add(listener);
    }

    public static synchronized void removeGlobalConfigModifiedListener(GlobalConfigModifiedListener listener) {
        listeners.remove(listener);
    }

    private static synchronized void fireGlobalConfigModified() {
        for (GlobalConfigModifiedListener listener : listeners) {
            try {
                listener.globalConfigModified();
            }
            catch (Throwable t) {
                log.error("A GlobalConfigModifiedListner failed.", t);
            }
        }
    }

    public static interface GlobalConfigModifiedListener {
        public void globalConfigModified();
    }
}

