/*
 * Decompiled with CFR 0.152.
 */
package pt.com.gcs.messaging;

import org.apache.commons.lang3.StringUtils;
import pt.com.broker.types.DeliverableMessage;
import pt.com.broker.types.NetBrokerMessage;
import pt.com.gcs.conf.GcsInfo;
import pt.com.gcs.messaging.MessageId;
import pt.com.gcs.messaging.MessageType;

public class InternalMessage
implements DeliverableMessage {
    public static final short CURRENT_VERSION = 1;
    public static final int DEFAULT_PRIORITY = 4;
    private static final long DEFAULT_EXPIRY = GcsInfo.getMessageStorageTime();
    private static final String SEPARATOR = "<#>";
    private String id;
    private NetBrokerMessage content;
    private String destination;
    private String correlationId;
    private int priority = 4;
    private String sourceApp = "Undefined Source";
    private long timestamp = System.currentTimeMillis();
    private long expiration = this.timestamp + DEFAULT_EXPIRY;
    private MessageType type = MessageType.UNDEF;
    private boolean isFromRemotePeer = false;
    private String publishingAgent = GcsInfo.getAgentName();
    private short version = 1;

    private void checkArg(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException("Invalid argument. Message initializers must not empty");
        }
    }

    private void checkArg(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Invalid argument. Message initializers must not be null");
        }
    }

    public InternalMessage() {
        this.setId(MessageId.getMessageId());
    }

    public InternalMessage(String destination, NetBrokerMessage content) {
        this.checkArg(destination);
        this.checkArg(content);
        this.content = content;
        this.destination = destination;
        this.setId(MessageId.getMessageId());
    }

    public InternalMessage(String id, String destination, NetBrokerMessage content) {
        this.checkArg(destination);
        this.checkArg(content);
        this.checkArg(id);
        this.content = content;
        this.destination = destination;
        this.setId(id);
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getMessageId() {
        return this.getId();
    }

    public void setMessageId(String id) {
        this.setId(id);
    }

    public NetBrokerMessage getContent() {
        return this.content;
    }

    public void setContent(NetBrokerMessage content) {
        this.content = content;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String cid) {
        if (StringUtils.isNotBlank((CharSequence)cid)) {
            this.correlationId = cid;
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getSourceApp() {
        return this.sourceApp;
    }

    public void setSourceApp(String sourceApp) {
        this.sourceApp = sourceApp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setType(MessageType type) {
        this.type = type;
    }

    public MessageType getType() {
        return this.type;
    }

    public void setFromRemotePeer(boolean isFromRemotePeer) {
        this.isFromRemotePeer = isFromRemotePeer;
    }

    public boolean isFromRemotePeer() {
        return this.isFromRemotePeer;
    }

    public void setPublishingAgent(String publishingAgent) {
        this.publishingAgent = publishingAgent;
    }

    public String getPublishingAgent() {
        return this.publishingAgent;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(100);
        buf.append(this.version);
        buf.append(SEPARATOR);
        buf.append(this.getContent());
        buf.append(SEPARATOR);
        buf.append(this.getCorrelationId());
        buf.append(SEPARATOR);
        buf.append(this.getDestination());
        buf.append(SEPARATOR);
        buf.append(this.getMessageId());
        buf.append(SEPARATOR);
        buf.append(this.getPublishingAgent());
        buf.append(SEPARATOR);
        buf.append(this.getPriority());
        buf.append(SEPARATOR);
        buf.append(this.getSourceApp());
        buf.append(SEPARATOR);
        buf.append(this.getTimestamp());
        buf.append(SEPARATOR);
        buf.append(this.getExpiration());
        buf.append(SEPARATOR);
        buf.append(this.getType().getValue());
        return buf.toString();
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setVersion(short version) {
        this.version = version;
    }

    public short getVersion() {
        return this.version;
    }
}

